/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.model.dataBoard.DataBoardConfig;
import com.digiwin.athena.agiledataquery.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.agiledataquery.service.IDataBoardService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/dataBoard"})
public class DataBoardController {
    private static final Logger log = LoggerFactory.getLogger(DataBoardController.class);
    @Autowired
    private IDataBoardService dataBoardService;

    @GetMapping(value={"/queryDataBoardConfig"})
    public Object queryDataBoardConfig(@RequestParam(required=false) String asaCode) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)asaCode)) {
            return this.dataBoardService.getQueryDataBoardConfig(asaCode);
        }
        return this.dataBoardService.getQueryDataBoardConfig();
    }

    @GetMapping(value={"/queryDataBoardConfigByAsaCode"})
    public Object queryDataBoardConfigByAsaCode(@RequestParam String asaCode) throws Exception {
        if (asaCode == null || asaCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "ASA\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.getQueryDataBoardConfig(asaCode);
    }

    @PostMapping(value={"/addDataBoardConfig"})
    public Object addDataBoardConfig(@RequestBody Map<String, Object> params) throws Exception {
        DataBoardConfig config = (DataBoardConfig)JSON.parseObject((String)JSON.toJSONString((Object)params.get("config")), DataBoardConfig.class);
        if (config == null) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.postAddDataBoardConfig(config);
    }

    @PostMapping(value={"/queryDataBoardConfig"})
    public Object queryDataBoardConfig(@RequestBody Map<String, Object> params) throws Exception {
        QueryConfigDTO queryConfig = (QueryConfigDTO)JSON.parseObject((String)JSON.toJSONString((Object)params.get("queryConfig")), QueryConfigDTO.class);
        if (queryConfig == null) {
            throw new DWBusinessException("500", "\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.postQueryDataBoardConfig(queryConfig);
    }

    @PostMapping(value={"/queryBoardStep"})
    public Object queryBoardStep(@RequestBody Map<String, Object> params) throws Exception {
        String questionId = (String)params.get("questionId");
        if (questionId == null || questionId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u95ee\u9898ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.postQueryBoardStep(questionId);
    }

    @PostMapping(value={"/queryBoardById"})
    public Object queryBoardById(@RequestBody Map<String, Object> params) throws Exception {
        String boardId = (String)params.get("boardId");
        if (boardId == null || boardId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u770b\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.postQueryBoardById(boardId);
    }

    @PostMapping(value={"/removeDataBoardConfig"})
    public Object removeDataBoardConfig(@RequestBody Map<String, Object> params) throws Exception {
        String boardId = (String)params.get("boardId");
        if (boardId == null || boardId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u770b\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.postRemoveDataBoardConfig(boardId);
    }

    @PostMapping(value={"/removeDataBoardQuestion"})
    public Object removeDataBoardQuestion(@RequestBody Map<String, Object> params) throws Exception {
        String questionId = (String)params.get("questionId");
        if (questionId == null || questionId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u95ee\u9898ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataBoardService.postRemoveDataBoardQuestion(questionId);
    }
}

