/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.model.dataCollect.DataCollectConfig;
import com.digiwin.athena.agiledataquery.model.dataCollect.QueryCollectDTO;
import com.digiwin.athena.agiledataquery.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.agiledataquery.service.IDataCollectService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/dataCollect"})
public class DataCollectController {
    private static final Logger log = LoggerFactory.getLogger(DataCollectController.class);
    @Autowired
    private IDataCollectService dataCollectService;

    @GetMapping(value={"/queryDataCollectConfig"})
    public Object queryDataCollectConfig(@RequestParam(required=false) String asaCode) throws Exception {
        if (!StringUtils.isEmpty((CharSequence)asaCode)) {
            return this.dataCollectService.getQueryDataCollectConfig(asaCode);
        }
        return this.dataCollectService.getQueryDataCollectConfig();
    }

    @GetMapping(value={"/queryDataCollectConfigByAsaCode"})
    public Object queryDataCollectConfigByAsaCode(@RequestParam String asaCode) throws Exception {
        if (asaCode == null || asaCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "ASA\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataCollectService.getQueryDataCollectConfig(asaCode);
    }

    @PostMapping(value={"/addDataCollectConfig"})
    public Object addDataCollectConfig(@RequestBody Map<String, Object> params) throws Exception {
        Object config = params.get("config");
        if (config == null) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataCollectConfig dataCollectConfig = (DataCollectConfig)JSON.parseObject((String)JSON.toJSONString((Object)config), DataCollectConfig.class);
        return this.dataCollectService.postAddDataCollectConfig(dataCollectConfig);
    }

    @PostMapping(value={"/queryDataCollectConfig"})
    public Object queryDataCollectConfig(@RequestBody Map<String, Object> params) throws Exception {
        Object config = params.get("queryConfig");
        if (config == null) {
            throw new DWBusinessException("500", "\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryConfigDTO queryConfig = (QueryConfigDTO)JSON.parseObject((String)JSON.toJSONString((Object)config), QueryConfigDTO.class);
        return this.dataCollectService.postQueryDataCollectConfig(queryConfig);
    }

    @PostMapping(value={"/removeDataCollectConfig"})
    public Object removeDataCollectConfig(@RequestBody Map<String, Object> params) throws Exception {
        Object config = params.get("config");
        if (config == null) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataCollectConfig dataCollectConfig = (DataCollectConfig)JSON.parseObject((String)JSON.toJSONString((Object)config), DataCollectConfig.class);
        return this.dataCollectService.postRemoveDataCollectConfig(dataCollectConfig);
    }

    @PostMapping(value={"/batchRemoveDataCollectConfig"})
    public Object batchRemoveDataCollectConfig(@RequestBody Map<String, Object> params) throws Exception {
        String asaCode = (String)params.get("asaCode");
        List groupIds = (List)params.get("groupIds");
        if (asaCode == null || asaCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "ASA\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (groupIds == null || groupIds.isEmpty()) {
            throw new DWBusinessException("500", "\u5206\u7ec4ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dataCollectService.postRemoveDataCollectConfig(asaCode, groupIds);
        return "\u5220\u9664\u6210\u529f";
    }

    @PostMapping(value={"/queryCollectStep"})
    public Object queryCollectStep(@RequestBody Map<String, Object> params) throws Exception {
        String questionId = (String)params.get("questionId");
        if (questionId == null || questionId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u95ee\u9898ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataCollectService.postQueryCollectStep(questionId);
    }

    @PostMapping(value={"/updateCollectByConfig"})
    public Object updateCollectByConfig(@RequestBody Map<String, Object> params) throws Exception {
        Object config = params.get("config");
        if (config == null) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryCollectDTO queryCollectDTO = (QueryCollectDTO)JSON.parseObject((String)JSON.toJSONString((Object)config), QueryCollectDTO.class);
        return this.dataCollectService.postUpdateCollectByConfig(queryCollectDTO);
    }
}

