/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.model.dataConfig.DataConfig;
import com.digiwin.athena.agiledataquery.service.IDataInsightsService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/agiledataquery/dataConfig"})
public class DataInsightsController {
    private static final Logger log = LoggerFactory.getLogger(DataInsightsController.class);
    @Autowired
    private IDataInsightsService dataInsightsService;

    @PostMapping(value={"/save"})
    public Object save(@RequestBody DataConfig dataConfig) throws DWBusinessException {
        if (dataConfig == null) {
            throw new DWBusinessException("500", "\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataInsightsService.saveOrUpdate(dataConfig);
    }

    @PostMapping(value={"/info"})
    public Object info(@RequestBody DataConfig dataConfig) throws DWBusinessException {
        if (dataConfig == null) {
            throw new DWBusinessException("500", "\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List dataList = this.dataInsightsService.list(dataConfig);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            dataConfig.setEnableDataInsights(Boolean.valueOf(false));
            dataConfig.setEnableDataRecommend(Boolean.valueOf(false));
            dataConfig.setEnableDataSearch(Boolean.valueOf(true));
        } else {
            dataConfig.setAppName(((DataConfig)dataList.get(0)).getAppName());
            dataConfig.setId(((DataConfig)dataList.get(0)).getId());
            dataConfig.setCreateDate(((DataConfig)dataList.get(0)).getCreateDate());
            dataConfig.setEnableDataInsights(Boolean.valueOf(((DataConfig)dataList.get(0)).getEnableDataInsights() != null && ((DataConfig)dataList.get(0)).getEnableDataInsights() != false));
            dataConfig.setEnableDataRecommend(Boolean.valueOf(((DataConfig)dataList.get(0)).getEnableDataRecommend() != null && ((DataConfig)dataList.get(0)).getEnableDataRecommend() != false));
            dataConfig.setEnableDataSearch(Boolean.valueOf(((DataConfig)dataList.get(0)).getEnableDataSearch() != null && ((DataConfig)dataList.get(0)).getEnableDataSearch() != false));
        }
        return dataConfig;
    }
}

