/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.agiledataquery.model.dataSubscription.QuerySubscriptionDTO;
import com.digiwin.athena.agiledataquery.service.IDataSubscriptionService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/dataSubscription"})
public class DataSubscriptionController {
    private static final Logger log = LoggerFactory.getLogger(DataSubscriptionController.class);
    @Autowired
    private IDataSubscriptionService dataSubscriptionService;

    @GetMapping(value={"/singleDataSubscriptionConfig"})
    public Object getSingleDataSubscriptionConfig(@RequestParam String ruleId) throws Exception {
        if (ruleId == null || ruleId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u89c4\u5219ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.getSingleDataSubscriptionConfig(ruleId);
    }

    @PostMapping(value={"/addDataSubscriptionConfig"})
    public Object addDataSubscriptionConfig(@RequestBody Map<String, Object> params) throws Exception {
        String config = JSON.toJSONString((Object)params.get("config"));
        if (StringUtils.isEmpty((CharSequence)config)) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DataSubscriptionRule dataSubscriptionRule = (DataSubscriptionRule)JSON.parseObject((String)config, DataSubscriptionRule.class);
        return this.dataSubscriptionService.postAddDataSubscriptionConfig(dataSubscriptionRule);
    }

    @PostMapping(value={"/queryDataSubscriptionConfig"})
    public Object queryDataSubscriptionConfig(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String question = (String)params.get("question");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        List datasetIdList = (List)params.get("datasetIdList");
        String asaCode = (String)params.get("asaCode");
        if (!StringUtils.isEmpty((CharSequence)asaCode)) {
            return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList, datasetIdList, asaCode);
        }
        if (!CollectionUtils.isEmpty((Collection)metricIdList) && !StringUtils.isEmpty((CharSequence)asaCode)) {
            return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList, asaCode);
        }
        if (!CollectionUtils.isEmpty((Collection)metricIdList)) {
            return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList);
        }
        return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode);
    }

    @PostMapping(value={"/queryDataSubscriptionConfigWithMetrics"})
    public Object queryDataSubscriptionConfigWithMetrics(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String question = (String)params.get("question");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        if (tenantId == null || tenantId.trim().isEmpty() || userId == null || userId.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u3001\u7528\u6237ID\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList);
    }

    @PostMapping(value={"/queryDataSubscriptionConfigWithAsa"})
    public Object queryDataSubscriptionConfigWithAsa(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String question = (String)params.get("question");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        String asaCode = (String)params.get("asaCode");
        if (tenantId == null || tenantId.trim().isEmpty() || userId == null || userId.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u3001\u7528\u6237ID\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList, asaCode);
    }

    @PostMapping(value={"/queryDataSubscriptionConfigFull"})
    public Object queryDataSubscriptionConfigFull(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String question = (String)params.get("question");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        List datasetIdList = (List)params.get("datasetIdList");
        String asaCode = (String)params.get("asaCode");
        if (tenantId == null || tenantId.trim().isEmpty() || userId == null || userId.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u3001\u7528\u6237ID\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, question, sceneCode, metricIdList, datasetIdList, asaCode);
    }

    @PostMapping(value={"/removeDataSubscriptionConfig"})
    public Object removeDataSubscriptionConfig(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        List datasetIdList = (List)params.get("datasetIdList");
        String question = (String)params.get("question");
        String asaCode = (String)params.get("asaCode");
        List ruleIds = (List)params.get("ruleIds");
        if (!CollectionUtils.isEmpty((Collection)ruleIds)) {
            return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, ruleIds);
        }
        if (!(CollectionUtils.isEmpty((Collection)metricIdList) && CollectionUtils.isEmpty((Collection)datasetIdList) || StringUtils.isEmpty((CharSequence)asaCode))) {
            return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, metricIdList, datasetIdList, question, asaCode);
        }
        if (!CollectionUtils.isEmpty((Collection)metricIdList) && !StringUtils.isEmpty((CharSequence)asaCode)) {
            return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, metricIdList, question, asaCode);
        }
        if (!CollectionUtils.isEmpty((Collection)metricIdList)) {
            return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, metricIdList, question);
        }
        return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, question);
    }

    @PostMapping(value={"/removeDataSubscriptionConfigWithMetrics"})
    public Object removeDataSubscriptionConfigWithMetrics(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        String question = (String)params.get("question");
        if (tenantId == null || tenantId.trim().isEmpty() || userId == null || userId.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u3001\u7528\u6237ID\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, metricIdList, question);
    }

    @PostMapping(value={"/removeDataSubscriptionConfigWithAsa"})
    public Object removeDataSubscriptionConfigWithAsa(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        String question = (String)params.get("question");
        String asaCode = (String)params.get("asaCode");
        if (tenantId == null || tenantId.trim().isEmpty() || userId == null || userId.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u3001\u7528\u6237ID\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, metricIdList, question, asaCode);
    }

    @PostMapping(value={"/removeDataSubscriptionConfigFull"})
    public Object removeDataSubscriptionConfigFull(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        String userId = (String)params.get("userId");
        String sceneCode = (String)params.get("sceneCode");
        List metricIdList = (List)params.get("metricIdList");
        List datasetIdList = (List)params.get("datasetIdList");
        String question = (String)params.get("question");
        String asaCode = (String)params.get("asaCode");
        if (tenantId == null || tenantId.trim().isEmpty() || userId == null || userId.trim().isEmpty() || sceneCode == null || sceneCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u3001\u7528\u6237ID\u548c\u573a\u666f\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, userId, sceneCode, metricIdList, datasetIdList, question, asaCode);
    }

    @PostMapping(value={"/removeDataSubscriptionConfigByRules"})
    public Object removeDataSubscriptionConfigByRules(@RequestBody Map<String, Object> params) throws Exception {
        String tenantId = (String)params.get("tenantId");
        List ruleIds = (List)params.get("ruleIds");
        if (tenantId == null || tenantId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u79df\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ruleIds == null || ruleIds.isEmpty()) {
            throw new DWBusinessException("500", "\u89c4\u5219ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postRemoveDataSubscriptionConfig(tenantId, ruleIds);
    }

    @PostMapping(value={"/appRenewDataSubscription"})
    public Object appRenewDataSubscription(@RequestBody Map<String, Object> params) throws Exception {
        List config = (List)params.get("config");
        if (config == null || config.isEmpty()) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dataSubscriptionService.postAppRenewDataSubscription(config);
        return "\u7eed\u7ea6\u6210\u529f";
    }

    @PostMapping(value={"/removeDataSubscription"})
    public Object removeDataSubscription(@RequestBody Map<String, Object> params) throws Exception {
        List config = (List)params.get("config");
        String type = (String)params.get("type");
        if (config == null || config.isEmpty()) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (type == null || type.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5220\u9664\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.dataSubscriptionService.postRemoveDataSubscription(config, type);
        return "\u5220\u9664\u6210\u529f";
    }

    @PostMapping(value={"/segmentDataSubscription"})
    public Object segmentDataSubscription(@RequestBody Map<String, Object> params) throws Exception {
        List ruleIds = (List)params.get("ruleIds");
        if (ruleIds == null || ruleIds.isEmpty()) {
            throw new DWBusinessException("500", "\u89c4\u5219ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postSegmentDataSubscription(ruleIds);
    }

    @PostMapping(value={"/updateSubscriptionByConfig"})
    public Object updateSubscriptionByConfig(@RequestBody Map<String, Object> params) throws Exception {
        QuerySubscriptionDTO config = (QuerySubscriptionDTO)JSON.parseObject((String)JSON.toJSONString((Object)params.get("config")), QuerySubscriptionDTO.class);
        if (config == null) {
            throw new DWBusinessException("500", "\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.dataSubscriptionService.postUpdateSubscriptionByConfig(config);
    }
}

