/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.service.IMetricService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/metric"})
public class MetricController {
    private static final Logger log = LoggerFactory.getLogger(MetricController.class);
    @Autowired
    private IMetricService metricService;

    @PostMapping(value={"/metricDataSource/v1"})
    public Object metricDataSourceV1(@RequestBody Map<String, Object> params) throws Exception {
        String appCode = (String)params.get("appCode");
        String version = (String)params.get("version");
        return this.metricService.metricDataSource(appCode, version);
    }

    @PostMapping(value={"/metricDataSource"})
    public Object metricDataSource(@RequestBody Map<String, Object> params) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        List indicatorIds = (List)params.get("indicatorIds");
        return this.metricService.metricDataSource(indicatorIds);
    }

    @PostMapping(value={"/metricQuerySchema"})
    public Object metricQuerySchema(@RequestBody Map<String, Object> params) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        List indicatorIds = (List)params.get("indicatorIds");
        return this.metricService.metricQuerySchema(indicatorIds);
    }

    @PostMapping(value={"/metricBusinessByCode"})
    public Object metricBusinessByCode(@RequestBody Map<String, Object> params) throws DWBusinessException {
        String tenantId = (String)params.get("tenantId");
        String appCode = (String)params.get("appCode");
        List codes = (List)params.get("codes");
        return this.metricService.metricBusinessByCode(tenantId, appCode, codes);
    }
}

