/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.model.ppt.PptDocument;
import com.digiwin.athena.agiledataquery.service.IPptService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/restful/service/agiledataquery/ppt"})
public class PptController {
    private static final Logger log = LoggerFactory.getLogger(PptController.class);
    @Autowired
    private IPptService pptService;

    @PostMapping(value={"/save"})
    public Object save(@RequestBody PptDocument pptObj) throws DWBusinessException {
        if (pptObj == null) {
            throw new DWBusinessException("500", "ppt\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.pptService.saveOrUpdate(pptObj);
    }

    @GetMapping(value={"/get"})
    public Object get(@RequestParam String pptId) throws DWBusinessException {
        if (StringUtils.isBlank((CharSequence)pptId)) {
            throw new DWBusinessException("500", "pptId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.pptService.getById(pptId);
    }

    @PostMapping(value={"/list"})
    public Object list(@RequestBody PptDocument pptObj) throws DWBusinessException {
        if (pptObj == null) {
            throw new DWBusinessException("500", "ppt\u67e5\u8be2\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.pptService.list(pptObj);
        return list;
    }

    @PostMapping(value={"/delete"})
    public Object delete(@RequestBody PptDocument pptObj) throws DWBusinessException {
        String pptId = pptObj.getPptId();
        String docId = pptObj.getPptDocId();
        if (StringUtils.isBlank((CharSequence)pptId) || StringUtils.isBlank((CharSequence)docId)) {
            throw new DWBusinessException("500", "pptId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.pptService.delete(pptId, docId);
    }

    @PostMapping(value={"/upload"}, consumes={"multipart/form-data"})
    public String uploadTwoFiles(@RequestPart(value="file1") MultipartFile file1, @RequestPart(value="file2") MultipartFile file2) {
        if (file1.isEmpty() || file2.isEmpty()) {
            return "\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a";
        }
        try {
            InputStream input1 = file1.getInputStream();
            InputStream input2 = file2.getInputStream();
            return "\u6536\u5230\u6587\u4ef61: " + file1.getOriginalFilename() + " (" + file1.getSize() + " bytes)\n\u6536\u5230\u6587\u4ef62: " + file2.getOriginalFilename() + " (" + file2.getSize() + " bytes)";
        }
        catch (IOException e) {
            return "\u6587\u4ef6\u5904\u7406\u5931\u8d25: " + e.getMessage();
        }
    }

    @GetMapping(value={"/setDefaultSystemPpt"})
    public Object setDefaultSystemPpt() throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        String userId = AthenaUtils.getUserId();
        if (StringUtils.isBlank((CharSequence)tenantId) || StringUtils.isBlank((CharSequence)userId)) {
            throw new DWBusinessException("500", "\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4e0a\u4e0b\u6587\u4fe1\u606f");
        }
        return this.pptService.setDefaultSystemPpt(tenantId, userId);
    }
}

