/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.digiwin.athena.agiledataquery.domain.OperationUnit;
import com.digiwin.athena.agiledataquery.domain.Task;
import com.digiwin.athena.agiledataquery.domain.activity.ExportAndImportConfig;
import com.digiwin.athena.agiledataquery.domain.config.MergeRule;
import com.digiwin.athena.agiledataquery.service.ITaskService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.vo.FindTaskFromUserRequest;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/task"})
public class TaskController {
    private static final Logger log = LoggerFactory.getLogger(TaskController.class);
    @Autowired
    private ITaskService taskService;

    @GetMapping(value={"/definition"})
    public Object definition(@RequestParam String taskId) throws Exception {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getDefinition(taskId);
    }

    @GetMapping(value={"/definitionWithMultiLanguage"})
    public Object definitionWithMultiLanguage(@RequestParam String taskId, @RequestParam(required=false) String pageCode) throws Exception {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageCode != null && !pageCode.trim().isEmpty()) {
            return this.taskService.getDefinitionWithMultiLanguage(taskId, pageCode);
        }
        return this.taskService.getDefinitionWithMultiLanguage(taskId);
    }

    @PostMapping(value={"/updateDefinitionWithMultiLanguage"})
    public Object updateDefinitionWithMultiLanguage(@RequestBody Map<String, Object> params) throws Exception {
        String taskId = (String)params.get("taskId");
        OperationUnit operationUnit = (OperationUnit)params.get("operationUnit");
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (operationUnit == null) {
            throw new DWBusinessException("500", "\u64cd\u4f5c\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postDefinitionWithMultiLanguage(taskId, operationUnit);
    }

    @GetMapping(value={"/activities"})
    public Object activities(@RequestParam String taskId) throws Exception {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getActivities(taskId);
    }

    @GetMapping(value={"/activitiesWithMultiLanguage"})
    public Object activitiesWithMultiLanguage(@RequestParam String taskId, @RequestParam(required=false) String compositionId) throws Exception {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (compositionId != null && !compositionId.trim().isEmpty()) {
            return this.taskService.getActivitiesWithMultiLanguage(taskId, compositionId);
        }
        return this.taskService.getActivitiesWithMultiLanguage(taskId);
    }

    @GetMapping(value={"/queryItem"})
    public Object queryItem(@RequestParam String condition) throws Exception {
        return this.taskService.getQueryItem(condition);
    }

    @GetMapping(value={"/activityNamesByCode"})
    public Object activityNamesByCode(@RequestParam String activityCode) throws Exception {
        if (activityCode == null || activityCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6d3b\u52a8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getActivityNamesByCode(activityCode);
    }

    @GetMapping(value={"/tbbReports"})
    public Object tbbReports(@RequestParam String mode, @RequestParam String productCode) throws Exception {
        if (mode == null || mode.trim().isEmpty() || productCode == null || productCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u5f0f\u548c\u4ea7\u54c1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getTBBReports(mode, productCode);
    }

    @GetMapping(value={"/baseDataApplication"})
    public Object baseDataApplication() throws Exception {
        return this.taskService.getBaseDataApplication();
    }

    @GetMapping(value={"/activitiesInfoByPattern"})
    public Object activitiesInfoByPattern() throws Exception {
        return this.taskService.getActivitiesInfoByPattern();
    }

    @GetMapping(value={"/activitiesByPattern"})
    public Object activitiesByPattern(@RequestParam String pattern) throws Exception {
        if (pattern == null || pattern.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getActivitiesByPattern(pattern);
    }

    @GetMapping(value={"/exportAndImportConfig"})
    public List<ExportAndImportConfig> exportAndImportConfig() throws Exception {
        return this.taskService.getExportAndImportConfig();
    }

    @GetMapping(value={"/activitiesByPatternAndAppCode"})
    public Object activitiesByPatternAndAppCode(@RequestParam String pattern, @RequestParam String appCode) throws Exception {
        if (pattern == null || pattern.trim().isEmpty() || appCode == null || appCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u5f0f\u548c\u5e94\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getActivitiesByPatternAndAppCode(pattern, appCode);
    }

    @GetMapping(value={"/activitiesAndSortByPattern"})
    public Object activitiesAndSortByPattern(@RequestParam String pattern) throws Exception {
        if (pattern == null || pattern.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getActivitiesAndSortByPattern(pattern);
    }

    @GetMapping(value={"/activityDefinition"})
    public Object activityDefinition(@RequestParam String activityId, @RequestParam String pageCode, @RequestParam(required=false) String taskId) throws Exception {
        if (activityId == null || activityId.trim().isEmpty() || pageCode == null || pageCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u6d3b\u52a8ID\u548c\u9875\u9762\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (taskId != null && !taskId.trim().isEmpty()) {
            return this.taskService.getActivityDefinition(taskId, activityId, pageCode);
        }
        return this.taskService.getActivityDefinition(activityId, pageCode);
    }

    @GetMapping(value={"/activityConfig"})
    public Object activityConfig(@RequestParam String activityId, @RequestParam(required=false) String taskId) throws Exception {
        if (taskId == null || taskId.trim().isEmpty() || activityId == null || activityId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u548c\u6d3b\u52a8ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getActivityConfig(taskId, activityId);
    }

    @GetMapping(value={"/tenantMergeConfig"})
    public Object tenantMergeConfig(@RequestParam String type, @RequestParam String code) throws Exception {
        if (type == null || type.trim().isEmpty() || code == null || code.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u7c7b\u578b\u548c\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getTenantMergeConfig(type, code);
    }

    @PostMapping(value={"/tenantMergeRule"})
    public Object tenantMergeRule(@RequestBody Map<String, Object> params) throws Exception {
        MergeRule mergeRule = (MergeRule)params.get("mergeRule");
        if (mergeRule == null) {
            throw new DWBusinessException("500", "\u5408\u5e76\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postTenantMergeRule(mergeRule);
    }

    @PostMapping(value={"/deleteTenantMergeRule"})
    public Object deleteTenantMergeRule(@RequestBody Map<String, Object> params) throws Exception {
        String type = (String)params.get("type");
        String code = (String)params.get("code");
        String application = (String)params.get("application");
        if (type == null || type.trim().isEmpty() || code == null || code.trim().isEmpty() || application == null || application.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u7c7b\u578b\u3001\u4ee3\u7801\u548c\u5e94\u7528\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postDeleteTenantMergeRule(type, code, application);
    }

    @PostMapping(value={"/updateActivityDefinition"})
    public Object updateActivityDefinition(@RequestBody Map<String, Object> params) throws Exception {
        String taskId = (String)params.get("taskId");
        String activityId = (String)params.get("activityId");
        String pageCode = (String)params.get("pageCode");
        OperationUnit operationUnit = (OperationUnit)params.get("operationUnit");
        if (taskId == null || taskId.trim().isEmpty() || activityId == null || activityId.trim().isEmpty() || pageCode == null || pageCode.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u3001\u6d3b\u52a8ID\u548c\u9875\u9762\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (operationUnit == null) {
            throw new DWBusinessException("500", "\u64cd\u4f5c\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postActivityDefinition(taskId, activityId, pageCode, operationUnit);
    }

    @GetMapping(value={"/allTasks"})
    public Object allTasks() throws Exception {
        return this.taskService.getAllTasks();
    }

    @GetMapping(value={"/appSubscription"})
    public Object appSubscription(@RequestParam String taskId) throws Exception {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getAppSubscription(taskId);
    }

    @PostMapping(value={"/updateTaskConfig"})
    public Object updateTaskConfig(@RequestBody Map<String, Object> params) throws Exception {
        String taskId = (String)params.get("taskId");
        Task data = (Task)params.get("data");
        OperationUnit operationUnit = (OperationUnit)params.get("operationUnit");
        if (operationUnit != null) {
            return this.taskService.postUpdateTaskConfig(data, operationUnit);
        }
        return this.taskService.postUpdateTaskConfig(data);
    }

    @GetMapping(value={"/tenantTask"})
    public Object tenantTask() throws Exception {
        return this.taskService.getTenantTask();
    }

    @GetMapping(value={"/tenantApplications"})
    public Object tenantApplications() throws Exception {
        return this.taskService.getTenantApplications();
    }

    @GetMapping(value={"/tenantTasksByAppCode"})
    public Object tenantTasksByAppCode(@RequestParam String code) throws Exception {
        if (code == null || code.trim().isEmpty()) {
            throw new DWBusinessException("500", "\u5e94\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.getTenantTasksByAppCode(code);
    }

    @PostMapping(value={"/taskList"})
    public Object taskList(@RequestBody Map<String, Object> query) throws Exception {
        if (query == null) {
            throw new DWBusinessException("500", "\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postTaskList(query);
    }

    @PostMapping(value={"/projectList"})
    public Object projectList(@RequestBody Map<String, Object> query) {
        if (query == null) {
            throw new DWBusinessException("500", "\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postProjectList(query);
    }

    @PostMapping(value={"/projectListBasic"})
    public Object projectListBasic(@RequestBody Map<String, Object> query) {
        if (query == null) {
            throw new DWBusinessException("500", "\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postProjectListBasic(query);
    }

    @PostMapping(value={"/findTaskFromUser"})
    public Object findTaskFromUser(@RequestBody Map<String, Object> params) throws Exception {
        FindTaskFromUserRequest findTaskFromUserRequest = (FindTaskFromUserRequest)params.get("findTaskFromUserRequest");
        if (findTaskFromUserRequest == null) {
            throw new DWBusinessException("500", "\u67e5\u8be2\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.taskService.postFindTaskFromUser(findTaskFromUserRequest);
    }
}

