/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.controller;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.domain.app.Application;
import com.digiwin.athena.agiledataquery.domain.valueobject.VirtualTenantParams;
import com.digiwin.athena.agiledataquery.dto.AppAddPurchaseNoticeDTO;
import com.digiwin.athena.agiledataquery.dto.ApplicationFunctionPermissionResultDTO;
import com.digiwin.athena.agiledataquery.dto.InitMonitorRuleParam;
import com.digiwin.athena.agiledataquery.dto.QueryPermissionSceneByCodeDTO;
import com.digiwin.athena.agiledataquery.dto.TenantAppNoticeDTO;
import com.digiwin.athena.agiledataquery.dto.TenantInitParam;
import com.digiwin.athena.agiledataquery.service.ITenantService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/restful/service/knowledgegraph/tenant"})
public class TenantController {
    @Autowired
    private ITenantService tenantService;

    @GetMapping(value={"/allTenant"})
    public Object getAllTenant() {
        return this.tenantService.getAllTenant();
    }

    @GetMapping(value={"/tenant"})
    public Object getTenant(@RequestParam String tenantId) {
        return this.tenantService.getTenant(tenantId);
    }

    @GetMapping(value={"/tenantVersion"})
    public Object getTenantVersion(@RequestParam String tenantId) {
        return this.tenantService.getTenantVersion(tenantId);
    }

    @PostMapping(value={"/deleteVirtualTenantToNodes"})
    public Object postDeleteVirtualTenantToNodes(@RequestBody VirtualTenantParams virtualTenantParams) {
        this.tenantService.postDeleteVirtualTenantToNodes(virtualTenantParams);
        return null;
    }

    @PostMapping(value={"/initTenantInfoV2"})
    public Object postInitTenantInfoV2(@RequestBody TenantInitParam param) {
        return this.tenantService.postInitTenantInfoV2(param);
    }

    @PostMapping(value={"/cleanTenantInfo"})
    public Object postCleanTenantInfo(@RequestBody TenantInitParam param) {
        return this.tenantService.postCleanTenantInfo(param);
    }

    @GetMapping(value={"/appCodes"})
    public Object getAppCodes() {
        return this.tenantService.getAppCodes();
    }

    @GetMapping(value={"/apps"})
    public Object getApps() {
        return this.tenantService.getApps();
    }

    @GetMapping(value={"/allTaskAndActivity"})
    public Object getAllTaskAndActivity() {
        return this.tenantService.getAllTaskAndActivity();
    }

    @PostMapping(value={"/initMonitorRuleForExistsTenant"})
    public Object postInitMonitorRuleForExistsTenant(@RequestBody InitMonitorRuleParam param) {
        return this.tenantService.postInitMonitorRuleForExistsTenant(param);
    }

    @PostMapping(value={"/handleTenantAppExpire"})
    public Object postHandleTenantAppExpire(@RequestBody InitMonitorRuleParam param) {
        return this.tenantService.postHandleTenantAppExpire(param);
    }

    @PostMapping(value={"/appRenewNotice"})
    public Object postAppRenewNotice(@RequestBody InitMonitorRuleParam param) {
        return this.tenantService.postAppRenewNotice(param);
    }

    @PostMapping(value={"/appAddPurchaseNotice"})
    public Object postAppAddPurchaseNotice(@RequestBody AppAddPurchaseNoticeDTO dto) {
        return this.tenantService.postAppAddPurchaseNotice(dto);
    }

    @PostMapping(value={"/tenantExpiredNotice"})
    public Object postTenantExpiredNotice(@RequestBody TenantAppNoticeDTO param) {
        return this.tenantService.postTenantExpiredNotice(param);
    }

    @PostMapping(value={"/tenantAppMaterialRemainNotice"})
    public Object postTenantAppMaterialRemainNotice(@RequestBody TenantAppNoticeDTO param) {
        return this.tenantService.postTenantAppMaterialRemainNotice(param);
    }

    @PostMapping(value={"/tenantAppRenewNotice"})
    public Object postTenantAppRenewNotice(@RequestBody TenantAppNoticeDTO param) {
        return this.tenantService.postTenantAppRenewNotice(param);
    }

    @GetMapping(value={"/userIntegrityCheck"})
    public Object getUserIntegrityCheck() {
        return this.tenantService.getUserIntegrityCheck();
    }

    @PostMapping(value={"/mockNoticeSuperAdminUserIntegrityCheckResult"})
    public Object postMockNoticeSuperAdminUserIntegrityCheckResult(JSONObject param) {
        this.tenantService.postMockNoticeSuperAdminUserIntegrityCheckResult(param);
        return null;
    }

    @GetMapping(value={"/appsInfo"})
    public Object getAppsInfo() {
        return this.tenantService.getAppsInfo();
    }

    @GetMapping(value={"/userAppAuth"})
    public Object userAppAuth(@RequestParam(required=false) String userId) throws Exception {
        if (userId != null && !userId.trim().isEmpty()) {
            return this.tenantService.getUserAppAuth(userId);
        }
        return this.tenantService.getUserAppAuth();
    }

    @GetMapping(value={"/userMetricApplication"})
    public List<Application> userMetricApplication(@RequestParam(required=false) String type, @RequestParam(required=false) String userId) throws Exception {
        if (userId != null && !userId.trim().isEmpty() && type != null && !type.trim().isEmpty()) {
            return this.tenantService.getUserMetricApplication(type, userId);
        }
        if (type != null && !type.trim().isEmpty()) {
            return this.tenantService.getUserMetricApplication(type);
        }
        return this.tenantService.getUserMetricApplication();
    }

    @GetMapping(value={"/tenantMetricApplication"})
    public Object getTenantMetricApplication() {
        return this.tenantService.getTenantMetricApplication();
    }

    @GetMapping(value={"/querySceneByTenant"})
    public Object getQuerySceneByTenant() {
        return this.tenantService.getQuerySceneByTenant();
    }

    @GetMapping(value={"/systemTenantServiceConfig"})
    public Object getSystemTenantServiceConfig(@RequestParam String tenantId, @RequestParam String serviceName) {
        return this.tenantService.getSystemTenantServiceConfig(tenantId, serviceName);
    }

    @PostMapping(value={"/queryPermissionSceneByCode"})
    public Object postQueryPermissionSceneByCode(@RequestBody QueryPermissionSceneByCodeDTO dto) throws NoSuchFieldException, IllegalAccessException {
        if (!CollectionUtils.isEmpty((Collection)dto.getAppCodes())) {
            return this.tenantService.postQueryPermissionSceneByCode(dto.getUserId(), dto.getAppCodes(), dto.getCodes());
        }
        if (!StringUtils.isEmpty((Object)dto.getUserId())) {
            return this.tenantService.postQueryPermissionSceneByCode(dto.getCodes(), dto.getUserId());
        }
        return this.tenantService.postQueryPermissionSceneByCode(dto.getCodes());
    }

    @PostMapping(value={"/queryProductLineByApp"})
    public Object postQueryProductLineByApp(@RequestBody Map<String, Object> request) {
        List appCodes = (List)request.get("appCodes");
        return this.tenantService.postQueryProductLineByApp(appCodes);
    }

    @PostMapping(value={"/handleTenantAppExpireRetainDaysAfter"})
    public void postHandleTenantAppExpireRetainDaysAfter() {
        this.tenantService.postHandleTenantAppExpireRetainDaysAfter();
    }

    @GetMapping(value={"/tenantUsersIntegrityCheck"})
    public void getTenantUsersIntegrityCheck() {
        this.tenantService.getTenantUsersIntegrityCheck();
    }

    @GetMapping(value={"/queryApplicationFunctionPermission"})
    public ApplicationFunctionPermissionResultDTO queryApplicationFunctionPermission(@RequestParam(value="appCode") String appCode) {
        return this.tenantService.queryApplicationFunctionPermission(appCode);
    }

    @GetMapping(value={"/queryUserJobFunctionPermissions"})
    public JSONObject queryUserJobFunctionPermissions(@RequestParam(value="appCode") String appCode) {
        return this.tenantService.queryUserJobFunctionPermissions(appCode);
    }
}

