/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.dao;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.domain.activity.Activity;
import com.digiwin.athena.agiledataquery.domain.common.HierarchicalEntity;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class MongoEntityBaseDAO {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    private String DEFAULT_TENANT_ID = "SYSTEM";

    public <T extends HierarchicalEntity> T findOne(Map<String, Object> keyConditions, Class<T> c) throws DWBusinessException {
        return (T)this.findOne(keyConditions, this.kgInnerService.getCurrentTenantVersion(), c);
    }

    public <T extends HierarchicalEntity> T findOne(Map<String, Object> keyConditions, String tenantVersion, Class<T> c) throws DWBusinessException {
        return (T)this.findOne(keyConditions, tenantVersion, c, null);
    }

    public <T extends HierarchicalEntity> T findOne(Map<String, Object> keyConditions, String tenantVersion, Class<T> c, String collectionName) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!this.DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(this.DEFAULT_TENANT_ID);
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> criteria.and(key).is(value));
        List queryResults = collectionName == null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c) : this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c, collectionName);
        for (HierarchicalEntity result : queryResults) {
            if (this.DEFAULT_TENANT_ID.equals(result.getTenantId()) || result.getTenantId() == null) continue;
            return (T)result;
        }
        if (queryResults.size() > 0) {
            return (T)((HierarchicalEntity)queryResults.get(0));
        }
        return null;
    }

    public <T extends HierarchicalEntity> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, Class<T> c, Map<String, Activity> activityMap) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.find(keyConditions, listKey, list, this.kgInnerService.getCurrentTenantVersion(), c, activityMap);
    }

    public <T extends HierarchicalEntity> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, String tenantVersion, Class<T> c, Map<String, Activity> activityMap) throws DWBusinessException {
        return this.find(keyConditions, listKey, list, tenantVersion, c, null, activityMap);
    }

    public <T extends HierarchicalEntity> Map<String, List<T>> find(Map<String, Object> keyConditions, String listKey, Collection list, String tenantVersion, Class<T> c, String collectionName, Map<String, Activity> activityMap) throws DWBusinessException {
        List queryResults;
        String tenantId = AthenaUtils.getTenantId();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!this.DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(this.DEFAULT_TENANT_ID);
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> criteria.and(key).is(value));
        criteria.and(listKey).in(list);
        List list2 = queryResults = collectionName == null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c) : this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c, collectionName);
        if (CollectionUtils.isEmpty((Collection)queryResults)) {
            return new HashMap<String, List<T>>();
        }
        Map groupedQueryResults = this.getGroupedQueryResults(keyConditions, listKey, queryResults, c);
        HashMap result = new HashMap();
        groupedQueryResults.forEach((k, v) -> {
            String groupedKey = k.substring(k.lastIndexOf("&") + 1);
            List<Object> keyList = CollectionUtils.isEmpty((Collection)((Collection)result.get(groupedKey))) ? new LinkedList() : (List)result.get(groupedKey);
            Activity activity = (Activity)activityMap.get(groupedKey);
            boolean ifCommon = activity != null && "common".equalsIgnoreCase(activity.getNameSpace());
            boolean added = false;
            for (HierarchicalEntity item : v) {
                if (!ifCommon && (this.DEFAULT_TENANT_ID.equals(item.getTenantId()) || item.getTenantId() == null)) continue;
                keyList.add(item);
                added = true;
                if (ifCommon) continue;
                break;
            }
            if (!added && v.size() > 0) {
                keyList.add(v.get(0));
            }
            result.put(groupedKey, keyList);
        });
        return result;
    }

    public <T extends HierarchicalEntity> List<T> find(Map<String, Object> keyConditions, Class<T> c) throws DWBusinessException {
        String tenantId = AthenaUtils.getTenantId();
        return this.find(keyConditions, this.kgInnerService.getCurrentTenantVersion(), c);
    }

    public <T extends HierarchicalEntity> List<T> find(Map<String, Object> keyConditions, String tenantVersion, Class<T> c) throws DWBusinessException {
        return this.find(keyConditions, tenantVersion, c, null);
    }

    public <T extends HierarchicalEntity> List<T> find(Map<String, Object> keyConditions, String tenantVersion, Class<T> c, String collectionName) throws DWBusinessException {
        List queryResults;
        String tenantId = AthenaUtils.getTenantId();
        ArrayList<String> tenantIds = new ArrayList<String>();
        tenantIds.add(tenantId);
        if (!this.DEFAULT_TENANT_ID.equals(tenantId)) {
            tenantIds.add(this.DEFAULT_TENANT_ID);
            tenantIds.add(null);
        }
        Criteria criteria = new Criteria();
        keyConditions.forEach((key, value) -> criteria.and(key).is(value));
        List list = queryResults = collectionName == null ? this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c) : this.mongoTemplate.find(Query.query((CriteriaDefinition)criteria.and("tenantId").in(tenantIds).and("version").is((Object)tenantVersion)), c, collectionName);
        if (CollectionUtils.isEmpty((Collection)queryResults)) {
            return new ArrayList();
        }
        Map groupedQueryResults = this.getGroupedQueryResults(keyConditions, queryResults, c);
        LinkedList result = new LinkedList();
        groupedQueryResults.values().forEach(group -> {
            boolean added = false;
            for (HierarchicalEntity item : group) {
                if (this.DEFAULT_TENANT_ID.equals(item.getTenantId()) || item.getTenantId() == null) continue;
                result.add(item);
                added = true;
                break;
            }
            if (!added && group.size() > 0) {
                result.add(group.get(0));
            }
        });
        return result;
    }

    private <T extends HierarchicalEntity> Map<String, List<T>> getGroupedQueryResults(Map<String, Object> keyConditions, String listKey, List<T> queryResults, Class<T> c) {
        List queryResultMapList = JSON.parseArray((String)JSON.toJSONString(queryResults), Map.class);
        Map<String, List<Map>> groupedQueryResults = queryResultMapList.stream().collect(Collectors.groupingBy(e -> this.buildKey(keyConditions.keySet(), listKey, e)));
        HashMap groupedQueryObjResults = new HashMap();
        groupedQueryResults.forEach((k, list) -> groupedQueryObjResults.put((String)k, JSON.parseArray((String)JSON.toJSONString((Object)list), (Class)c)));
        return groupedQueryObjResults;
    }

    private String buildKey(Collection normalKey, String listKey, Map result) {
        String normalKeyStr = String.valueOf(normalKey.stream().map(item -> String.valueOf(result.get(item))).collect(Collectors.joining("&")));
        return StringUtils.isEmpty((CharSequence)normalKeyStr) ? String.valueOf(result.get(listKey)) : normalKeyStr + "&" + result.get(listKey);
    }

    private <T extends HierarchicalEntity> Map<String, List<T>> getGroupedQueryResults(Map<String, Object> keyConditions, List<T> queryResults, Class<T> c) {
        List queryResultMapList = JSON.parseArray((String)JSON.toJSONString(queryResults), Map.class);
        Map<String, List<Map>> groupedQueryResults = queryResultMapList.stream().collect(Collectors.groupingBy(e -> keyConditions.keySet().stream().map(item -> String.valueOf(e.get(item))).collect(Collectors.joining("&"))));
        HashMap groupedQueryObjResults = new HashMap();
        groupedQueryResults.forEach((k, list) -> groupedQueryObjResults.put((String)k, JSON.parseArray((String)JSON.toJSONString((Object)list), (Class)c)));
        return groupedQueryObjResults;
    }
}

