/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.filter;

import com.digiwin.athena.agiledataquery.filter.UrlCaseInsensitiveFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlCaseInsensitiveFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(UrlCaseInsensitiveFilter.class);
    private static final String PROCESSED_ATTRIBUTE = "url_case_insensitive_processed";

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("UrlCaseInsensitiveFilter initialized");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String correctedLastSegment;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getAttribute(PROCESSED_ATTRIBUTE) != null) {
            logger.debug("Request already processed by UrlCaseInsensitiveFilter, skipping...");
            chain.doFilter(request, response);
            return;
        }
        httpRequest.setAttribute(PROCESSED_ATTRIBUTE, (Object)Boolean.TRUE);
        String originalUri = httpRequest.getRequestURI();
        String contextPath = httpRequest.getContextPath();
        String relativePath = originalUri;
        if (contextPath != null && !contextPath.isEmpty()) {
            relativePath = originalUri.substring(contextPath.length());
        }
        if (!relativePath.startsWith("/restful/service/knowledgegraph")) {
            chain.doFilter(request, response);
            return;
        }
        CharSequence[] pathSegments = relativePath.split("/");
        if (pathSegments.length < 2) {
            chain.doFilter(request, response);
            return;
        }
        String lastSegment = pathSegments[pathSegments.length - 1];
        if (lastSegment.isEmpty() || Character.isLowerCase(lastSegment.charAt(0))) {
            chain.doFilter(request, response);
            return;
        }
        pathSegments[pathSegments.length - 1] = correctedLastSegment = Character.toLowerCase(lastSegment.charAt(0)) + (lastSegment.length() > 1 ? lastSegment.substring(1) : "");
        String correctedPath = String.join((CharSequence)"/", pathSegments);
        String correctedUri = (contextPath != null ? contextPath : "") + correctedPath;
        logger.debug("URL\u8def\u5f84\u8f6c\u6362: {} -> {}", (Object)originalUri, (Object)correctedUri);
        1 requestWrapper = new /* Unavailable Anonymous Inner Class!! */;
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    public void destroy() {
        logger.info("UrlCaseInsensitiveFilter destroyed");
    }
}

