/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.digiwin.athena.agiledataquery.model.assistDimension.AssistDimensionConfig;
import com.digiwin.athena.agiledataquery.model.assistDimension.AssistDimensionTenantConfig;
import com.digiwin.athena.agiledataquery.service.IAssistDimensionService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AssistDimensionServiceImpl
implements IAssistDimensionService {
    private static final Logger log = LoggerFactory.getLogger(AssistDimensionServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplate")
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    KgInnerService kgInnerService;

    public Object postQueryAssistDimension(String appCode, List<String> dimensions) throws Exception {
        List assistDimensionTenantConfigs;
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        String tenantId = AthenaUtils.getTenantId();
        Map<String, List> resultMap = dimensions.stream().collect(Collectors.toMap(dimension -> dimension, dimension -> Collections.emptyList(), (existing, replacement) -> existing));
        List assistDimensionConfigs = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"key").in(dimensions).and("appCode").is((Object)appCode).and("version").is((Object)tenantVersion)), AssistDimensionConfig.class);
        if (!CollectionUtils.isEmpty((Collection)assistDimensionConfigs)) {
            resultMap.putAll(assistDimensionConfigs.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll));
        }
        if (!CollectionUtils.isEmpty((Collection)(assistDimensionTenantConfigs = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)Criteria.where((String)"key").in(dimensions).and("appCode").is((Object)appCode).and("tenantId").is((Object)tenantId)), AssistDimensionTenantConfig.class)))) {
            resultMap.putAll(assistDimensionTenantConfigs.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue()), HashMap::putAll));
        }
        return resultMap;
    }
}

