/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.CACUtils;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.domain.app.Application;
import com.digiwin.athena.agiledataquery.domain.common.BaseEntity;
import com.digiwin.athena.agiledataquery.dto.ReportSceneDTOs;
import com.digiwin.athena.agiledataquery.service.ICommandService;
import com.digiwin.athena.agiledataquery.service.IScreenService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.LanguageUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CommandServiceImpl
implements ICommandService {
    private static final Logger log = LoggerFactory.getLogger(CommandServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    private IScreenService screenServiceImpl;
    @Autowired
    private KgService kgService;
    @Value(value="${deploy.cloud:''}")
    private String deployCloud;

    public Object queryCommandIntentions(String userId) throws Exception {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List appCodes = this.cacUtils.getAppAuth(userId);
        List commandIntentions = this.mongoTemplate.find(this.queryCriteria(appCodes, tenantVersion), Map.class, "agiledata_instruction_set");
        if (CollectionUtils.isEmpty((Collection)commandIntentions)) {
            return Collections.emptyList();
        }
        List applicationCodes = commandIntentions.stream().map(commandIntention -> (String)commandIntention.get("applicationCode")).distinct().collect(Collectors.toList());
        List permissionCodes = this.screenServiceImpl.getUserPermissionScreen(userId, Arrays.asList("scene", "metric"), applicationCodes);
        commandIntentions.forEach(commandIntention -> this.filterIntentions(commandIntention, permissionCodes));
        LanguageUtil.processLocaleLanguage((Object)commandIntentions, (String)AthenaUtils.getCurrentLocale());
        return commandIntentions;
    }

    public Object dataSetCommandIntentions(String appCode, String version) throws Exception {
        Map application;
        String userId = AthenaUtils.getUserId();
        String tenantVersion = version;
        if (StringUtils.isEmpty((CharSequence)tenantVersion)) {
            tenantVersion = this.kgInnerService.currentTenantVersion();
        }
        if (Objects.isNull(application = (Map)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"code").is((Object)appCode).and("version").is((Object)tenantVersion)), Map.class, "application"))) {
            return Collections.emptyMap();
        }
        HashMap commandIntentionInfo = new HashMap();
        commandIntentionInfo.put("name", application.get("name"));
        commandIntentionInfo.put("introduction", application.get("introduction"));
        commandIntentionInfo.put("prompt", application.get("prompt"));
        commandIntentionInfo.put("commandIntentions", Collections.emptyList());
        commandIntentionInfo.put("appType", application.get("appType"));
        commandIntentionInfo.put("iconUrl", application.get("iconUrl"));
        commandIntentionInfo.put("lang", application.get("lang"));
        commandIntentionInfo.put("appSystem", application.get("appSystem"));
        List permissionCodes = this.screenServiceImpl.getUserPermissionScreen(userId, new ArrayList(), Collections.singletonList(appCode));
        if (CollectionUtils.isEmpty((Collection)permissionCodes)) {
            return commandIntentionInfo;
        }
        List dataSetList = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("appCode").is((Object)appCode)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        if (CollectionUtils.isEmpty((Collection)dataSetList)) {
            return commandIntentionInfo;
        }
        ArrayList commandIntentions = new ArrayList();
        for (ReportSceneDTOs dataSet : dataSetList) {
            if (CollectionUtils.isEmpty((Collection)dataSet.getQuestions())) continue;
            HashMap<String, Object> dataSetInfo = new HashMap<String, Object>();
            dataSetInfo.put("code", dataSet.getCode());
            dataSetInfo.put("name", dataSet.getName());
            dataSetInfo.put("questions", dataSet.getQuestions());
            dataSetInfo.put("modelCode", dataSet.getModelCode());
            dataSetInfo.put("lang", dataSet.getLang());
            commandIntentions.add(dataSetInfo);
        }
        commandIntentionInfo.put("commandIntentions", commandIntentions);
        LanguageUtil.processLocaleLanguage(commandIntentionInfo, (String)AthenaUtils.getCurrentLocale());
        return commandIntentionInfo;
    }

    public Object queryAllCommandIntentions(String userId) throws Exception {
        if (Objects.equals(this.deployCloud, "cloud")) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("userId", userId);
            return this.kgService.doForwardToKg(param);
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        List appCodes = this.cacUtils.getAppAuth(userId);
        List applications = this.mongoTemplate.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in((Collection)appCodes).and("version").is((Object)tenantVersion)), Application.class, "application");
        List applicationCodes = applications.stream().map(BaseEntity::getCode).distinct().collect(Collectors.toList());
        List commandIntentions = this.mongoTemplate.find(this.queryCriteria(applicationCodes, tenantVersion), Map.class, "agiledata_instruction_set");
        List permissionCodes = this.screenServiceImpl.getUserPermissionScreen(userId, new ArrayList(), applicationCodes);
        commandIntentions.forEach(commandIntention -> this.filterIntentions(commandIntention, permissionCodes));
        LanguageUtil.processLocaleLanguage((Object)commandIntentions, (String)AthenaUtils.getCurrentLocale());
        return commandIntentions;
    }

    private Query queryCriteria(List<String> appCode, String tenantVersion) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"applicationCode").in(appCode).and("version").is((Object)tenantVersion));
        return query;
    }

    private void filterIntentions(Map<String, Object> commandIntention, List<String> permissionCodes) {
        List intentions = (List)commandIntention.get("intentions");
        if (CollectionUtils.isEmpty((Collection)intentions)) {
            return;
        }
        List filteredIntentions = intentions.stream().filter(intention -> intention.get("relationValue") != null && permissionCodes.contains(intention.get("relationValue").toString()) || intention.get("relationValue") == null && intention.get("intention") != null).collect(Collectors.toList());
        commandIntention.put("intentions", filteredIntentions);
    }

    private List<Map> filterDataSetIntentions(List<ReportSceneDTOs> reportSceneDTOList, List<String> permissionCodes) {
        return reportSceneDTOList.stream().filter(reportScenes -> CollectionUtils.isNotEmpty((Collection)reportScenes.getQuestions()) && permissionCodes.contains(reportScenes.getCode())).map(arg_0 -> this.convertToDataSetInfo(arg_0)).collect(Collectors.toList());
    }

    private Map<String, Object> convertToDataSetInfo(ReportSceneDTOs reportScenes) {
        HashMap<String, Object> dataSetInfo = new HashMap<String, Object>();
        dataSetInfo.put("code", reportScenes.getCode());
        dataSetInfo.put("intentionGroupCode", reportScenes.getCode());
        dataSetInfo.put("intentionGroupName", ((Map)reportScenes.getLang().get("sceneTitle")).getOrDefault(AthenaUtils.getCurrentLocale(), reportScenes.getSceneTitle()));
        dataSetInfo.put("version", reportScenes.getVersion());
        dataSetInfo.put("applicationCode", reportScenes.getAppCode());
        dataSetInfo.put("lang", reportScenes.getLang());
        List intentions = reportScenes.getQuestions().stream().map(question -> {
            HashMap<String, Object> intention = new HashMap<String, Object>();
            intention.put("relationType", 1);
            intention.put("relationName", reportScenes.getName());
            intention.put("relationValue", reportScenes.getCode());
            JSONObject lang = (JSONObject)question.get((Object)"lang");
            Object value = lang.getOrDefault((Object)AthenaUtils.getCurrentLocale(), question.get((Object)"question"));
            intention.put("intention", value);
            intention.put("lang", question.get((Object)"lang"));
            intention.put("sort", 999);
            intention.put("relationStatus", 1);
            return intention;
        }).collect(Collectors.toList());
        dataSetInfo.put("intentions", intentions);
        return dataSetInfo;
    }
}

