/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.digiwin.athena.agiledataquery.model.dataBoard.DataBoardConfig;
import com.digiwin.athena.agiledataquery.model.dataCollect.QueryConfigDTO;
import com.digiwin.athena.agiledataquery.service.IDataBoardService;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DataBoardServiceImpl
implements IDataBoardService {
    private static final Logger log = LoggerFactory.getLogger(DataBoardServiceImpl.class);
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";
    private static final Pattern NAME_SEQ = Pattern.compile("^(.*)(?:\\((\\d+)\\)|\uff08(\\d+)\uff09)$");
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    ISceneService sceneService;

    public Object postAddDataBoardConfig(DataBoardConfig config) throws Exception {
        List configs;
        if (StringUtils.isEmpty((CharSequence)config.getTenantId()) || StringUtils.isEmpty((CharSequence)config.getUserId()) || CollectionUtils.isEmpty((Collection)config.getDataBoardQuestions())) {
            return FAIL_MSG;
        }
        String boardId = config.getBoardId();
        String currentLocale = AthenaUtils.getCurrentLocale();
        if (!StringUtils.isEmpty((CharSequence)boardId) && !CollectionUtils.isEmpty((Collection)(configs = this.getQueryDataBoardConfig(config.getAsaCode())))) {
            for (DataBoardConfig oldConfig : configs) {
                if (Objects.equals(oldConfig.getBoardId(), boardId) || !Objects.equals(config.getBoardName(), oldConfig.getBoardName())) continue;
                if (Objects.equals("zh_TW", currentLocale)) {
                    throw new DWBusinessException("P.KG.500.99999", "\u6578\u64da\u770b\u677f\u540d\u7a31\u4e0d\u80fd\u91cd\u5fa9\uff0c\u8acb\u4fee\u6539");
                }
                throw new DWBusinessException("P.KG.500.99999", "\u6570\u636e\u770b\u677f\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539");
            }
        }
        if (StringUtils.isEmpty((CharSequence)boardId)) {
            String userId = AthenaUtils.getUserId();
            String tenantId = AthenaUtils.getTenantId();
            String boardName = config.getBoardName();
            String name = this.nextAvailableName(tenantId, userId, boardName, DataBoardConfig.class);
            config.setBoardName(name);
            boardId = "board_" + UUID.randomUUID().toString().replace("-", "");
            config.setBoardId(boardId);
            List boardQuestions = config.getDataBoardQuestions();
            boardQuestions.forEach(q -> q.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", "")));
            config.setDataBoardQuestions(boardQuestions);
            this.mongoTemplateUser.save((Object)config);
        } else {
            List dataBoardQuestions = config.getDataBoardQuestions();
            for (DataBoardConfig.DataBoardQuestions boardQuestion : dataBoardQuestions) {
                if (!StringUtils.isEmpty((CharSequence)boardQuestion.getQuestionId())) continue;
                boardQuestion.setQuestionId("question_" + UUID.randomUUID().toString().replace("-", ""));
            }
            this.updateDataBoardConfig(boardId, config, dataBoardQuestions);
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("boardId", boardId);
        result.put("status", SUCCESS_MSG);
        return result;
    }

    public String nextAvailableName(String tenantId, String userId, String wantName, Class<?> entityClass) {
        String base = wantName;
        for (int loop = 0; loop < 999; ++loop) {
            boolean exist = this.mongoTemplateUser.exists(Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId).and("boardName").is((Object)base)), entityClass);
            if (!exist) {
                return base;
            }
            Criteria c = Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId).and("boardName").regex("^" + Pattern.quote(base) + "(?:\\(\\d+\\)|\uff08\\d+\uff09)$");
            List suffixList = this.mongoTemplateUser.find(Query.query((CriteriaDefinition)c), entityClass).stream().map(doc -> ((DataBoardConfig)doc).getBoardName()).collect(Collectors.toList());
            int max = 0;
            for (String n : suffixList) {
                Matcher m = NAME_SEQ.matcher(n);
                if (!m.matches()) continue;
                String num = m.group(2) != null ? m.group(2) : m.group(3);
                max = Math.max(max, Integer.parseInt(num));
            }
            base = base + "\uff08" + (max + 1) + "\uff09";
        }
        throw new DWBusinessException("\u540d\u79f0\u5c42\u7ea7\u8fc7\u6df1\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
    }

    public List<DataBoardConfig> getQueryDataBoardConfig() throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        return this.mongoTemplateUser.find(query, DataBoardConfig.class);
    }

    public List<DataBoardConfig> getQueryDataBoardConfig(String asaCode) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId).and("asaCode").is((Object)asaCode));
        return this.mongoTemplateUser.find(query, DataBoardConfig.class);
    }

    public Object postQueryBoardStep(String questionId) {
        DataBoardConfig dataCollectConfigs = (DataBoardConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"dataBoardQuestions.questionId").is((Object)questionId)), DataBoardConfig.class);
        if (ObjectUtils.isEmpty((Object)dataCollectConfigs)) {
            return Collections.emptyMap();
        }
        List collectConfigs = dataCollectConfigs.getDataBoardQuestions();
        if (CollectionUtils.isEmpty((Collection)collectConfigs)) {
            return Collections.emptyMap();
        }
        List filteredList = collectConfigs.stream().filter(collectConfig -> Objects.equals(questionId, collectConfig.getQuestionId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredList) || filteredList.get(0) == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("questionId", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getQuestionId());
        map.put("solutionStep", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getSolutionStep());
        map.put("question", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getQuestion());
        map.put("snapshotId", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getSnapshotId());
        map.put("showType", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getShowType());
        map.put("boardId", dataCollectConfigs.getBoardId());
        map.put("appCode", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getAppCode());
        map.put("filterAnalysis", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getFilterAnalysis());
        map.put("stepFilterAnalysis", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getStepFilterAnalysis());
        map.put("chartTitle", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getChartTitle());
        map.put("dataParam", ((DataBoardConfig.DataBoardQuestions)filteredList.get(0)).getDataParam());
        map.put("dataEntry", dataCollectConfigs.getDataEntry());
        map.put("messageId", dataCollectConfigs.getMessageId());
        return map;
    }

    public Object postQueryBoardById(String boardId) throws Exception {
        return this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId)), DataBoardConfig.class);
    }

    public Object postQueryDataBoardConfig(QueryConfigDTO queryConfig) throws Exception {
        List dataCollectConfigs = this.getQueryDataBoardConfig(queryConfig.getAsaCode());
        if (StringUtils.isEmpty((CharSequence)queryConfig.getGroupId()) || CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return dataCollectConfigs;
        }
        List collectConfigs = ((DataBoardConfig)dataCollectConfigs.get(0)).getDataBoardQuestions();
        if (null != collectConfigs) {
            ((DataBoardConfig)dataCollectConfigs.get(0)).setDataBoardQuestions(collectConfigs);
        }
        return this.sceneService.getTranslateContent((Object)dataCollectConfigs);
    }

    public Object postRemoveDataBoardConfig(String boardId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)boardId)) {
            return SUCCESS_MSG;
        }
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"boardId").is((Object)boardId)), DataBoardConfig.class);
        return SUCCESS_MSG;
    }

    public void updateDataBoardConfig(String boardId, DataBoardConfig config, List<DataBoardConfig.DataBoardQuestions> dataBoardQuestions) throws Exception {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("boardId").is((Object)boardId).and("userId").is((Object)config.getUserId()));
        Update update = new Update();
        update.set("dataBoardQuestions", dataBoardQuestions);
        update.set("boardName", (Object)config.getBoardName());
        update.set("asaCode", (Object)config.getAsaCode());
        if (StringUtils.isNotEmpty((CharSequence)config.getDataEntry())) {
            update.set("dataEntry", (Object)config.getDataEntry());
        }
        this.mongoTemplateUser.updateMulti(query, (UpdateDefinition)update, DataBoardConfig.class);
    }

    public void postRemoveDataBoardConfig(List<String> groupIds) throws Exception {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        List dataCollectConfigs = this.mongoTemplateUser.find(query, DataBoardConfig.class);
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return;
        }
        List dataCollectQuestions = ((DataBoardConfig)dataCollectConfigs.get(0)).getDataBoardQuestions();
        if (CollectionUtils.isEmpty((Collection)dataCollectQuestions)) {
            return;
        }
        this.updateDataBoardConfig(((DataBoardConfig)dataCollectConfigs.get(0)).getBoardId(), (DataBoardConfig)dataCollectConfigs.get(0), dataCollectQuestions);
    }

    public Object postRemoveDataBoardQuestion(String questionId) throws Exception {
        if (StringUtils.isEmpty((CharSequence)questionId)) {
            return SUCCESS_MSG;
        }
        DataBoardConfig configs = (DataBoardConfig)this.mongoTemplateUser.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"dataBoardQuestions.questionId").is((Object)questionId)), DataBoardConfig.class);
        if (Objects.isNull(configs)) {
            return SUCCESS_MSG;
        }
        List questions = configs.getDataBoardQuestions();
        if (CollectionUtils.isEmpty((Collection)questions)) {
            return SUCCESS_MSG;
        }
        configs.getDataBoardQuestions().removeIf(dataBoardQuestion -> Objects.equals(questionId, dataBoardQuestion.getQuestionId()));
        this.updateDataBoardConfig(configs.getBoardId(), configs, configs.getDataBoardQuestions());
        return SUCCESS_MSG;
    }
}

