/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.digiwin.athena.agiledataquery.clients.CACUtils;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.model.dataCollect.DataCollectConfig;
import com.digiwin.athena.agiledataquery.model.dataCollect.DataCollectQuestions;
import com.digiwin.athena.agiledataquery.model.dataCollectGroup.DataCollectGroupConfig;
import com.digiwin.athena.agiledataquery.model.dataCollectGroup.DelConfigDTO;
import com.digiwin.athena.agiledataquery.service.IDataCollectGroupService;
import com.digiwin.athena.agiledataquery.service.IDataCollectService;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DataCollectGroupServiceImpl
implements IDataCollectGroupService {
    private static final Logger log = LoggerFactory.getLogger(DataCollectGroupServiceImpl.class);
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateUser;
    @Autowired
    IDataCollectService dataCollectService;
    @Autowired
    ISceneService sceneService;
    @Autowired
    CACUtils cacUtils;
    public static final String FAIL_MSG = "fail";
    public static final String SUCCESS_MSG = "success";

    public Object postAddDataCollectGroupConfig(List<DataCollectGroupConfig> configs) {
        if (CollectionUtils.isEmpty(configs)) {
            return FAIL_MSG;
        }
        BulkOperations bulkOperations = this.mongoTemplateUser.bulkOps(BulkOperations.BulkMode.UNORDERED, DataCollectGroupConfig.class);
        for (DataCollectGroupConfig config : configs) {
            if (StringUtils.isEmpty((CharSequence)config.getGroupId())) {
                config.setGroupId("group_" + UUID.randomUUID().toString().replace("-", ""));
            }
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)config.getTenantId()).and("groupId").is((Object)config.getGroupId()).and("userId").is((Object)config.getUserId()).and("type").is((Object)config.getType()));
            Update update = new Update().set("orderId", (Object)config.getOrderId()).set("groupValue", (Object)config.getGroupValue()).set("asaCode", (Object)config.getAsaCode()).set("type", (Object)config.getType()).set("userName", (Object)config.getUserName());
            bulkOperations.upsert(query, update);
        }
        bulkOperations.execute();
        return SUCCESS_MSG;
    }

    public Object postRemoveDataCollectGroupConfig(DelConfigDTO delConfig) throws Exception {
        if (CollectionUtils.isEmpty((Collection)delConfig.getGroupIds())) {
            return FAIL_MSG;
        }
        this.mongoTemplateUser.remove(Query.query((CriteriaDefinition)Criteria.where((String)"groupId").in((Collection)delConfig.getGroupIds())), DataCollectGroupConfig.class);
        this.dataCollectService.postRemoveDataCollectConfig(delConfig.getAsaCode(), delConfig.getGroupIds());
        return SUCCESS_MSG;
    }

    public Object postQueryDataCollectGroupConfig(DataCollectGroupConfig config) throws Exception {
        Query query = this.queryCriteria(config);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List groupList = this.mongoTemplateUser.find(query, DataCollectGroupConfig.class);
        if (CollectionUtils.isEmpty((Collection)groupList) && StringUtils.isEmpty((CharSequence)config.getGroupValue())) {
            DataCollectGroupConfig dataCollectGroupConfig = this.getDataCollectGroupConfig(config);
            groupList.add(dataCollectGroupConfig);
            this.postAddDataCollectGroupConfig(groupList);
            this.assignGroupIdToCollectQuestion(config, dataCollectGroupConfig);
        }
        Map collectData = this.getDataCollectQuestionsConfig(config);
        result.put("groupData", groupList);
        result.put("collectData", collectData);
        result.put("sysData", this.getSysGroupData());
        return this.sceneService.getTranslateContent(result);
    }

    private Object getSysGroupData() throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new DWBusinessException("userId is empty");
        }
        List uniqueAppCodes = this.cacUtils.getAppAuth(userId);
        if (CollectionUtils.isEmpty((Collection)uniqueAppCodes)) {
            return Collections.emptyList();
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"appCode").in((Collection)uniqueAppCodes).and("version").is((Object)tenantVersion));
        return this.mongoTemplate.find(query, Object.class, "agiledata_board_info");
    }

    private Query queryCriteria(DataCollectGroupConfig config) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        String tenantId = AthenaUtils.getTenantId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("userId").is((Object)userId));
        if (StringUtils.isNotEmpty((CharSequence)config.getGroupId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"groupId").is((Object)config.getGroupId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getType())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"type").is((Object)config.getType()));
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getGroupValue())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"groupValue").is((Object)config.getGroupValue()));
        }
        if (StringUtils.isNotEmpty((CharSequence)config.getAsaCode())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"asaCode").is((Object)config.getAsaCode()));
        } else {
            Criteria criteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"asaCode").is((Object)""), Criteria.where((String)"asaCode").is(null)});
            query.addCriteria((CriteriaDefinition)criteria);
        }
        query.with(Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"orderId"}));
        return query;
    }

    private DataCollectGroupConfig getDataCollectGroupConfig(DataCollectGroupConfig config) {
        DataCollectGroupConfig groupConfig = new DataCollectGroupConfig();
        groupConfig.setGroupId("group_" + UUID.randomUUID().toString().replace("-", ""));
        groupConfig.setOrderId(Integer.valueOf(1));
        groupConfig.setTenantId(StringUtils.isEmpty((CharSequence)config.getTenantId()) ? DWServiceContext.getContext().getProfile().get("tenantId").toString() : config.getTenantId());
        groupConfig.setUserId(StringUtils.isEmpty((CharSequence)config.getUserId()) ? DWServiceContext.getContext().getProfile().get("userId").toString() : config.getUserId());
        groupConfig.setUserName(StringUtils.isEmpty((CharSequence)config.getUserName()) ? DWServiceContext.getContext().getProfile().get("userName").toString() : config.getUserName());
        groupConfig.setGroupValue("\u9ed8\u8ba4");
        groupConfig.setType("user");
        groupConfig.setAsaCode(config.getAsaCode());
        return groupConfig;
    }

    private void assignGroupIdToCollectQuestion(DataCollectGroupConfig config, DataCollectGroupConfig dataCollectGroupConfig) throws Exception {
        List dataCollectConfigs = StringUtils.isEmpty((CharSequence)config.getAsaCode()) ? this.dataCollectService.getQueryDataCollectConfig() : this.dataCollectService.getQueryDataCollectConfig(config.getAsaCode());
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return;
        }
        DataCollectConfig dataCollectConfig = (DataCollectConfig)dataCollectConfigs.get(0);
        List dataCollectQuestions = dataCollectConfig.getDataCollectQuestions();
        if (!CollectionUtils.isEmpty((Collection)dataCollectQuestions)) {
            dataCollectQuestions.forEach(dataCollectQuestion -> {
                dataCollectQuestion.setGroupId(dataCollectGroupConfig.getGroupId());
                dataCollectQuestion.setGroupValue(dataCollectGroupConfig.getGroupValue());
            });
            this.dataCollectService.updateDataCollectConfig(dataCollectConfig.getBoardId(), dataCollectConfig, dataCollectQuestions);
        }
    }

    public Map<String, List<DataCollectQuestions>> getDataCollectQuestionsConfig(DataCollectGroupConfig config) throws Exception {
        List dataCollectConfigs;
        List list = dataCollectConfigs = StringUtils.isNotEmpty((CharSequence)config.getAsaCode()) ? this.dataCollectService.getQueryDataCollectConfig(config.getAsaCode()) : this.dataCollectService.getQueryDataCollectConfig();
        if (CollectionUtils.isEmpty((Collection)dataCollectConfigs)) {
            return Collections.emptyMap();
        }
        List dataCollectQuestions = ((DataCollectConfig)dataCollectConfigs.get(0)).getDataCollectQuestions();
        if (CollectionUtils.isEmpty((Collection)dataCollectQuestions)) {
            return Collections.emptyMap();
        }
        return dataCollectQuestions.stream().collect(Collectors.groupingBy(DataCollectQuestions::getGroupId));
    }
}

