/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.digiwin.athena.agiledataquery.model.dataConfig.DataConfig;
import com.digiwin.athena.agiledataquery.service.IDataInsightsService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class DataInsightsServiceImpl
implements IDataInsightsService {
    private static final Logger log = LoggerFactory.getLogger(DataInsightsServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplateTenant;

    public Object saveOrUpdate(DataConfig dataConfig) throws DWBusinessException {
        Query query;
        DataConfig exists;
        if (dataConfig == null) {
            throw new DWBusinessException("500", "\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)dataConfig.getTenantId())) {
            dataConfig.setTenantId(AthenaUtils.getTenantId());
        }
        if (StringUtils.isBlank((CharSequence)dataConfig.getId())) {
            dataConfig.setId("dataConfig_" + UUID.randomUUID().toString().replace("-", ""));
        }
        if ((exists = (DataConfig)this.mongoTemplateTenant.findOne(query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)dataConfig.getId())), DataConfig.class)) == null) {
            if (StringUtils.isBlank((CharSequence)dataConfig.getCreateDate())) {
                dataConfig.setCreateDate(ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
            this.mongoTemplateTenant.insert((Object)dataConfig);
        } else {
            dataConfig.setCreateDate(exists.getCreateDate());
            this.mongoTemplateTenant.remove(query, DataConfig.class);
            this.mongoTemplateTenant.insert((Object)dataConfig);
        }
        HashMap<String, DataConfig> result = new HashMap<String, DataConfig>();
        result.put("data", dataConfig);
        return result;
    }

    public List<DataConfig> list(DataConfig dataConfig) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)(StringUtils.isBlank((CharSequence)dataConfig.getTenantId()) ? AthenaUtils.getTenantId() : dataConfig.getTenantId()));
        if (StringUtils.isNotBlank((CharSequence)dataConfig.getAppCode())) {
            criteria = criteria.and("appCode").is((Object)dataConfig.getAppCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dataConfig.getAppName())) {
            criteria = criteria.and("appName").is((Object)dataConfig.getAppName());
        }
        Query query = Query.query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        return this.mongoTemplateTenant.find(query, DataConfig.class);
    }
}

