/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.digiwin.athena.agiledataquery.model.file.FileDocument;
import com.digiwin.athena.agiledataquery.service.IFileService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements IFileService {
    private static final Logger log = LoggerFactory.getLogger(FileServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplateTenant;
    private static final String COLLECTION = "agiledata_file";

    public Object saveOrUpdate(FileDocument file) throws DWBusinessException {
        Query query;
        FileDocument exists;
        if (file == null) {
            throw new DWBusinessException("500", "\u6587\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)file.getTenantId())) {
            file.setTenantId(AthenaUtils.getTenantId());
        }
        if (StringUtils.isBlank((CharSequence)file.getUserId())) {
            file.setUserId(AthenaUtils.getUserId());
        }
        if (StringUtils.isBlank((CharSequence)file.getId())) {
            file.setId(file.getType() + "_" + UUID.randomUUID().toString().replace("-", ""));
        }
        if ((exists = (FileDocument)this.mongoTemplateTenant.findOne(query = Query.query((CriteriaDefinition)Criteria.where((String)"id").is((Object)file.getId())), FileDocument.class, COLLECTION)) == null) {
            if (StringUtils.isBlank((CharSequence)file.getCreateDate())) {
                file.setCreateDate(ZonedDateTime.now().format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
            }
            this.mongoTemplateTenant.insert((Object)file, COLLECTION);
        } else {
            file.setCreateDate(exists.getCreateDate());
            this.mongoTemplateTenant.remove(query, FileDocument.class, COLLECTION);
            this.mongoTemplateTenant.insert((Object)file, COLLECTION);
        }
        HashMap<String, FileDocument> result = new HashMap<String, FileDocument>();
        result.put("data", file);
        return result;
    }

    public FileDocument getById(String id, String dmcId) throws DWBusinessException {
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)dmcId)) {
            throw new DWBusinessException("500", "\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (FileDocument)this.mongoTemplateTenant.findOne(Query.query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id), Criteria.where((String)"dmcId").is((Object)dmcId)})), FileDocument.class, COLLECTION);
    }

    public List<FileDocument> list(FileDocument file) throws DWBusinessException {
        Criteria criteria = Criteria.where((String)"tenantId").is((Object)(StringUtils.isBlank((CharSequence)file.getTenantId()) ? AthenaUtils.getTenantId() : file.getTenantId()));
        if (StringUtils.isNotBlank((CharSequence)file.getUserId())) {
            criteria = criteria.and("userId").is((Object)file.getUserId());
        }
        if (StringUtils.isNotBlank((CharSequence)file.getType())) {
            criteria = criteria.and("type").is((Object)file.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)file.getName())) {
            criteria = criteria.and("name").is((Object)file.getName());
        }
        if (StringUtils.isNotBlank((CharSequence)file.getUrl())) {
            criteria = criteria.and("url").is((Object)file.getUrl());
        }
        Query query = Query.query((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        return this.mongoTemplateTenant.find(query, FileDocument.class, COLLECTION);
    }

    public Object delete(FileDocument fileObj) throws DWBusinessException {
        String id = fileObj.getId();
        String dmcId = fileObj.getDmcId();
        if (StringUtils.isBlank((CharSequence)id) && StringUtils.isBlank((CharSequence)dmcId)) {
            throw new DWBusinessException("500", "\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mongoTemplateTenant.remove(Query.query((CriteriaDefinition)new Criteria().orOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id), Criteria.where((String)"dmcId").is((Object)dmcId)})), FileDocument.class, COLLECTION);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("deleted", true);
        return result;
    }
}

