/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.dto.ReportSceneDTOs;
import com.digiwin.athena.agiledataquery.model.standardParams.PermissionSchemas;
import com.digiwin.athena.agiledataquery.model.standardParams.StandardParams;
import com.digiwin.athena.agiledataquery.model.standardParams.StandardParamsDTO;
import com.digiwin.athena.agiledataquery.service.IParameterService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.DataMapFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ParameterService
implements IParameterService {
    private static final Logger log = LoggerFactory.getLogger(ParameterService.class);
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    KgInnerService kgInnerService;
    @Autowired
    KgService kgService;
    public static final List<String> OPERATOR_TYPE = Arrays.asList("eq", "ne", "like", "rl", "nrl", "ll", "nll", "gt", "gte", "lt", "lte", "between", "in", "nin", "null", "nn");

    public Object getParameter(String appCode, String tenantId) {
        String tenantVersion = "1.0";
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("version").is((Object)tenantVersion).and("application").is((Object)appCode).and("data_type").is((Object)"string");
        query.addCriteria((CriteriaDefinition)criteria);
        List standardParams = this.mongoTemplate.find(query, StandardParams.class);
        if (CollectionUtils.isEmpty((Collection)standardParams)) {
            return Collections.singletonList(permissionSchemas);
        }
        ArrayList standardParamsDTOS = new ArrayList();
        standardParams.forEach(item -> standardParamsDTOS.add(StandardParamsDTO.builder().id(item.getData_name()).name(item.getName()).dataType(item.getData_type()).dataSource("api").filterType(item.getOperator()).build()));
        permissionSchemas.setFields(standardParamsDTOS);
        return Collections.singletonList(permissionSchemas);
    }

    public Object getParameter(String appId, String tenantId, String moduleId, String actionId) throws DWBusinessException {
        ReportSceneDTOs dataSet;
        DataMapFilter.getLoginInfo().setTenantId(tenantId);
        String tenantVersion = "1.0";
        PermissionSchemas permissionSchemas = new PermissionSchemas();
        if (StringUtils.isNotBlank((CharSequence)tenantId)) {
            tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        }
        if (Objects.isNull(dataSet = (ReportSceneDTOs)this.mongoTemplate.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("appCode").is((Object)appId).and("code").is((Object)actionId)), ReportSceneDTOs.class, "agiledatainquiry_data_set"))) {
            List<String> sceneCodes = Collections.singletonList(actionId);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("code", sceneCodes.get(0));
            Object queryData = this.kgService.doForwardToKg("/restful/service/knowledgegraph/scene/querySceneMaps", HttpMethod.POST, params);
            ReportSceneDTOs reportScene = null;
            if (!ObjectUtils.isEmpty((Object)queryData)) {
                reportScene = (ReportSceneDTOs)JSON.parseObject((String)JSON.toJSONString((Object)queryData), ReportSceneDTOs.class);
            }
            if (Objects.isNull(reportScene) || !Objects.equals(reportScene.getViewType(), "dataset")) {
                Query query = new Query();
                Criteria criteria = new Criteria();
                criteria.and("version").is((Object)tenantVersion).and("application").is((Object)appId).and("data_type").is((Object)"string");
                query.addCriteria((CriteriaDefinition)criteria);
                List standardParams = this.mongoTemplate.find(query, StandardParams.class);
                if (CollectionUtils.isEmpty((Collection)standardParams)) {
                    return Collections.singletonList(permissionSchemas);
                }
                ArrayList standardParamsDTOS = new ArrayList();
                standardParams.forEach(item -> standardParamsDTOS.add(StandardParamsDTO.builder().id(item.getData_name()).name(item.getName()).dataType(item.getData_type()).dataSource("api").filterType(item.getOperator()).build()));
                permissionSchemas.setFields(standardParamsDTOS);
            } else {
                List fieldSchemas = reportScene.getFieldSchema();
                ArrayList<StandardParamsDTO> standardParamsDTOS = new ArrayList<StandardParamsDTO>();
                for (Object fieldSchema : fieldSchemas) {
                    Map item2 = (Map)fieldSchema;
                    standardParamsDTOS.add(StandardParamsDTO.builder().id(item2.get("name").toString()).name(item2.get("title").toString()).dataType(item2.get("dataType").toString()).dataSource("api").filterType(OPERATOR_TYPE).build());
                }
                permissionSchemas.setFields(standardParamsDTOS);
                permissionSchemas.setName(reportScene.getSceneTitle());
                permissionSchemas.setId(reportScene.getCode());
            }
        } else {
            List dimensions = dataSet.getDimensions();
            dimensions.addAll(dataSet.getMeasures());
            ArrayList<StandardParamsDTO> standardParamsDTOS = new ArrayList<StandardParamsDTO>();
            for (Object dimension : dimensions) {
                Map item3 = (Map)dimension;
                standardParamsDTOS.add(StandardParamsDTO.builder().id(item3.get("data_name").toString()).name(item3.getOrDefault("name", "").toString()).dataType(item3.get("data_type").toString()).dataSource("api").filterType(OPERATOR_TYPE).build());
            }
            permissionSchemas.setFields(standardParamsDTOS);
            permissionSchemas.setName(dataSet.getName());
            permissionSchemas.setId(dataSet.getCode());
        }
        return Collections.singletonList(permissionSchemas);
    }
}

