/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.digiwin.athena.agiledataquery.clients.ATMCService;
import com.digiwin.athena.agiledataquery.clients.CACUtils;
import com.digiwin.athena.agiledataquery.clients.CacService;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.clients.KgService;
import com.digiwin.athena.agiledataquery.constant.Constants;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.domain.TenantEntity;
import com.digiwin.athena.agiledataquery.domain.app.Application;
import com.digiwin.athena.agiledataquery.domain.valueobject.VirtualTenantParams;
import com.digiwin.athena.agiledataquery.dto.AppAddPurchaseNoticeDTO;
import com.digiwin.athena.agiledataquery.dto.ApplicationFunctionPermissionResultDTO;
import com.digiwin.athena.agiledataquery.dto.InitMonitorRuleParam;
import com.digiwin.athena.agiledataquery.dto.ReportSceneDTOs;
import com.digiwin.athena.agiledataquery.dto.TenantAppNoticeDTO;
import com.digiwin.athena.agiledataquery.dto.TenantInitParam;
import com.digiwin.athena.agiledataquery.model.sence.PermissionSceneDTO;
import com.digiwin.athena.agiledataquery.service.ISceneService;
import com.digiwin.athena.agiledataquery.service.IScreenService;
import com.digiwin.athena.agiledataquery.service.ITenantService;
import com.digiwin.athena.agiledataquery.service.inner.DataPickService;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.utils.AthenaUtils;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import com.digiwin.athena.agiledataquery.utils.JsonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class TenantServiceImpl
implements ITenantService {
    private static final Logger log = LoggerFactory.getLogger(TenantServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    MongoTemplate mongoTemplateTenant;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplateSystem;
    @Autowired
    private KgService kgService;
    @Autowired
    private CacService cacService;
    @Autowired
    private ATMCService atmcService;
    @Autowired
    private KgInnerService kgInnerService;
    @Autowired
    private DataPickService dataPickService;
    @Autowired
    private CACUtils cacUtils;
    @Autowired
    private IScreenService iScreenService;
    @Autowired
    private IScreenService screenService;
    @Autowired
    private ISceneService sceneService;
    @Autowired
    private IamService iamService;

    public List<TenantEntity> getAllTenant() {
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"ifCommon").in(new Object[]{null, false})), TenantEntity.class);
    }

    public TenantEntity getTenant(String tenantId) {
        return (TenantEntity)this.mongoTemplateSystem.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantEntity.class);
    }

    public String getTenantVersion(String tenantId) {
        boolean timedTask = false;
        String version = null;
        try {
            version = (String)DWServiceContext.getContext().getRequestHeader().get(tenantId + "tenantVersion");
        }
        catch (Exception e) {
            timedTask = true;
            log.info("getTenantVersion warn");
        }
        if (null != version) {
            return version;
        }
        String cacheKey = "knowledgegraph:SYSTEM:" + tenantId + ":tenantversion";
        version = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        if (null != version) {
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);
            return version;
        }
        TenantEntity tenantEntity = (TenantEntity)this.mongoTemplateSystem.findOne(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId)), TenantEntity.class);
        if (null == tenantEntity || null == tenantEntity.getVersion()) {
            version = "2.0";
            log.warn("P.KG.500.0006\uff0cmessage\uff1a{}", (Object)I18nUtils.getValue((String)"knowledgegraph.tenantEmpty", (Object[])new Object[]{tenantId}));
        } else {
            version = tenantEntity.getVersion();
        }
        this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)version, 7200L, TimeUnit.SECONDS);
        if (!timedTask) {
            DWServiceContext.getContext().getRequestHeader().put(tenantId + "tenantVersion", version);
        }
        return version;
    }

    public void postDeleteVirtualTenantToNodes(VirtualTenantParams virtualTenantParams) {
        Map requestBody = (Map)JSON.parseObject((String)JSON.toJSONString((Object)virtualTenantParams), Map.class);
        this.kgService.doForwardToKg(requestBody);
    }

    public Object postInitTenantInfoV2(TenantInitParam param) {
        HashMap<String, TenantInitParam> req = new HashMap<String, TenantInitParam>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object postCleanTenantInfo(TenantInitParam param) {
        HashMap<String, TenantInitParam> req = new HashMap<String, TenantInitParam>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public List<String> getAppCodes() {
        String tenantId = AthenaUtils.getTenantId();
        return this.cacService.getAuthorizationsApplication(tenantId);
    }

    public List<String> getAppCodes(String tenantId) throws DWBusinessException {
        return this.cacService.getAuthorizationsApplication(tenantId);
    }

    public Object getApps() {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object getAllTaskAndActivity() {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object postInitMonitorRuleForExistsTenant(InitMonitorRuleParam param) {
        HashMap<String, InitMonitorRuleParam> req = new HashMap<String, InitMonitorRuleParam>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object postHandleTenantAppExpire(InitMonitorRuleParam param) {
        HashMap<String, InitMonitorRuleParam> req = new HashMap<String, InitMonitorRuleParam>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object postAppRenewNotice(InitMonitorRuleParam param) {
        HashMap<String, InitMonitorRuleParam> req = new HashMap<String, InitMonitorRuleParam>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object postAppAddPurchaseNotice(AppAddPurchaseNoticeDTO dto) {
        Map req = (Map)JSON.parseObject((String)JSON.toJSONString((Object)dto), Map.class);
        return this.kgService.doForwardToKg(req);
    }

    public Object postTenantExpiredNotice(TenantAppNoticeDTO param) {
        HashMap<String, TenantAppNoticeDTO> req = new HashMap<String, TenantAppNoticeDTO>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object postTenantAppMaterialRemainNotice(TenantAppNoticeDTO param) {
        HashMap<String, TenantAppNoticeDTO> req = new HashMap<String, TenantAppNoticeDTO>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object postTenantAppRenewNotice(TenantAppNoticeDTO param) {
        HashMap<String, TenantAppNoticeDTO> req = new HashMap<String, TenantAppNoticeDTO>();
        req.put("param", param);
        return this.kgService.doForwardToKg(req);
    }

    public Object getUserIntegrityCheck() {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public void postMockNoticeSuperAdminUserIntegrityCheckResult(JSONObject param) {
        this.atmcService.noticeSuperAdminUserIntegrityCheckResult(param);
    }

    public Object getAppsInfo() {
        HashMap<String, Object> appInfo = new HashMap<String, Object>();
        List tenantAppRelations = this.dataPickService.tenantInitializedApps(AthenaUtils.getTenantId());
        appInfo.put("tenantAppInfos", tenantAppRelations);
        appInfo.put("tenantVersion", this.kgInnerService.currentTenantVersion());
        return appInfo;
    }

    public Object getUserAppAuth() {
        String userId = AthenaUtils.getUserId();
        if (StringUtils.isEmpty((CharSequence)userId)) {
            throw new DWBusinessException("userId is empty");
        }
        return this.getUserAppAuth(userId);
    }

    public Object getUserAppAuth(String userId) {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        HashMap<String, Object> tenantAppInfos = new HashMap<String, Object>();
        List appCodes = this.cacUtils.getAppAuth(userId);
        tenantAppInfos.put("appCodes", this.cacUtils.getAppAuth(userId));
        tenantAppInfos.put("tenantVersion", this.kgInnerService.currentTenantVersion());
        tenantAppInfos.put("tenantId", AthenaUtils.getTenantId());
        tenantAppInfos.put("userId", userId);
        if (CollectionUtils.isNotEmpty((Collection)appCodes)) {
            List applications = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"code").in((Collection)appCodes)), Map.class, "application");
            tenantAppInfos.put("applications", applications);
        }
        return tenantAppInfos;
    }

    public List<Application> getUserMetricApplication() {
        return this.getUserMetricApplication("1");
    }

    public List<Application> getUserMetricApplication(String type) throws DWBusinessException {
        String userId = AthenaUtils.getUserId();
        return this.getUserMetricApplication(type, userId);
    }

    public List<Application> getUserMetricApplication(String type, String userId) throws DWBusinessException {
        if (StringUtils.isEmpty((CharSequence)userId)) {
            userId = AthenaUtils.getUserId();
        }
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List appCodes = this.cacUtils.getAppAuth(userId);
        if (StringUtils.equals((CharSequence)type, (CharSequence)"1")) {
            return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in((Collection)appCodes).and("appType").in(new Object[]{6, 12})), Application.class);
        }
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in((Collection)appCodes)), Application.class);
    }

    public List<Application> getTenantMetricApplication() {
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List appCodes = this.cacService.getAuthorizationsApplication(tenantId);
        return this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in((Collection)appCodes).and("appType").in(new Object[]{6, 12})), Application.class);
    }

    public Object getQuerySceneByTenant() {
        return this.kgService.doForwardToKg(new HashMap());
    }

    public Object getSystemTenantServiceConfig(String tenantId, String serviceName) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("tenantId", tenantId);
        req.put("serviceName", serviceName);
        return this.kgService.doForwardToKg(req);
    }

    public Object postQueryPermissionSceneByCode(List<String> codes) throws NoSuchFieldException, IllegalAccessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        String userId = AthenaUtils.getUserId();
        List dataSets = this.mongoTemplateTenant.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        List<Object> reportScenes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataSets)) {
            List applicationCodes = dataSets.stream().map(ReportSceneDTOs::getAppCode).distinct().collect(Collectors.toList());
            List permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList(), applicationCodes);
            reportScenes = dataSets.stream().map(scene -> {
                boolean isAuthorized = permissionCodes.contains(scene.getCode());
                PermissionSceneDTO dto = new PermissionSceneDTO();
                dto.setCode(scene.getCode());
                dto.setSceneTitle(scene.getName());
                dto.setIsAuthorized(Boolean.valueOf(isAuthorized));
                return dto;
            }).collect(Collectors.toList());
            return this.sceneService.getTranslateContent(reportScenes);
        }
        HashMap<String, List<String>> req = new HashMap<String, List<String>>();
        req.put("codes", codes);
        return this.kgService.doForwardToKg(req);
    }

    public Object postQueryPermissionSceneByCode(String userId, List<String> appCodes, List<String> codes) throws DWBusinessException {
        if (CollectionUtils.isEmpty(appCodes) || CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        List permissionCodes = this.iScreenService.getUserPermissionScreen(userId, Arrays.asList("scene", "metric"), appCodes);
        if (CollectionUtils.isEmpty((Collection)permissionCodes)) {
            return Collections.emptyList();
        }
        return codes.stream().filter(permissionCodes::contains).collect(Collectors.toList());
    }

    public Object postQueryPermissionSceneByCode(List<String> codes, String userId) throws DWBusinessException, NoSuchFieldException, IllegalAccessException {
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        List dataSets = this.mongoTemplateSystem.find(Query.query((CriteriaDefinition)Criteria.where((String)"version").is((Object)tenantVersion).and("code").in(codes)), ReportSceneDTOs.class, "agiledatainquiry_data_set");
        List<Object> reportScenes = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dataSets)) {
            List applicationCodes = dataSets.stream().map(ReportSceneDTOs::getAppCode).distinct().collect(Collectors.toList());
            List permissionCodes = this.screenService.getUserPermissionScreen(userId, new ArrayList(), applicationCodes);
            reportScenes = dataSets.stream().map(scene -> {
                boolean isAuthorized = permissionCodes.contains(scene.getCode());
                PermissionSceneDTO dto = new PermissionSceneDTO();
                dto.setCode(scene.getCode());
                dto.setSceneTitle(scene.getName());
                dto.setIsAuthorized(Boolean.valueOf(isAuthorized));
                return dto;
            }).collect(Collectors.toList());
            return this.sceneService.getTranslateContent(reportScenes);
        }
        HashMap<String, Object> req = new HashMap<String, Object>();
        req.put("codes", codes);
        req.put("userId", userId);
        return this.kgService.doForwardToKg(req);
    }

    public Object postQueryProductLineByApp(List<String> appCodes) {
        if (CollectionUtils.isEmpty(appCodes)) {
            return Collections.emptyMap();
        }
        String tenantId = AthenaUtils.getTenantId();
        String tenantVersion = this.kgInnerService.getTenantVersion(tenantId);
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"code").in(appCodes).and("version").is((Object)tenantVersion));
        List applications = this.mongoTemplateSystem.find(query, Application.class);
        return appCodes.stream().collect(Collectors.toMap(appCode -> appCode, appCode -> applications.stream().filter(application -> application.getCode().equals(appCode)).findFirst().map(Application::getProductLines).orElse(Collections.emptyList()), (existing, replacement) -> existing));
    }

    public void postHandleTenantAppExpireRetainDaysAfter() {
        this.kgService.doForwardToKg(new HashMap());
    }

    public void getTenantUsersIntegrityCheck() {
        this.kgService.doForwardToKg(new HashMap());
    }

    public ApplicationFunctionPermissionResultDTO queryApplicationFunctionPermission(String appCode) {
        log.info("queryApplicationFunctionPermission appCode:{}", (Object)appCode);
        String tenantVersion = this.kgInnerService.currentTenantVersion();
        Criteria criteria = new Criteria();
        criteria.and("code").is((Object)appCode).and("version").is((Object)tenantVersion);
        List applications = this.mongoTemplateSystem.find(new Query((CriteriaDefinition)criteria), Application.class);
        if (CollectionUtils.isEmpty((Collection)applications)) {
            return null;
        }
        List appCodes = this.cacUtils.getAppAuth(AthenaUtils.getUserId());
        log.info("queryApplicationFunctionPermission applications:\n {}", (Object)JSON.toJSONString((Object)applications));
        ApplicationFunctionPermissionResultDTO result = new ApplicationFunctionPermissionResultDTO();
        applications.forEach(app -> {
            if (Constants.six.equals(app.getAppType()) && "dataset".equals(app.getAppSystem()) || Constants.twelve.equals(app.getAppType())) {
                result.setMethod("dataset");
            }
            if (Constants.six.equals(app.getAppType()) && "metric".equals(app.getAppSystem())) {
                result.setMethod("metric");
            }
            result.setFunctionModules(app.getFunctionModules());
            result.setModuleInfo(app.getModuleInfo());
            if (CollectionUtils.isNotEmpty((Collection)appCodes) && !appCodes.contains("1216700ALL000003")) {
                if (ObjectUtils.isNotEmpty((Object)result.getFunctionModules())) {
                    result.getFunctionModules().remove("intelligent-analyst");
                }
                if (ObjectUtils.isNotEmpty((Object)result.getModuleInfo())) {
                    result.getModuleInfo().remove("intelligent-analyst");
                }
            }
        });
        return result;
    }

    public JSONObject queryUserJobFunctionPermissions(String appCode) {
        log.info("queryUserJobFunctionPermissions appCode:{}", (Object)appCode);
        String userId = AthenaUtils.getUserId();
        String token = AthenaUtils.getHeaderToken();
        JSONObject jsonObject = new JSONObject();
        try {
            Object userPermission = this.iamService.getUserPermission(appCode, userId, token);
            boolean superAdmin = this.iamService.isSuperAdmin(userId, token);
            if (BooleanUtils.isTrue((Boolean)superAdmin)) {
                jsonObject.put("superAdmin", (Object)true);
                return jsonObject;
            }
            log.info("queryUserJobFunctionPermissions iam result:\n{}", (Object)JsonUtil.toJsonString((Object)userPermission));
            JSONObject res = (JSONObject)JsonUtil.toObject((String)JsonUtil.toJsonString((Object)userPermission), JSONObject.class);
            if (res != null && ((Integer)res.getObject("code", Integer.class)).intValue() == HttpStatus.OK.value()) {
                List list = (List)JsonUtil.toObject((String)res.getString("data"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return jsonObject;
                }
                list.stream().filter(permission -> permission.getTarget() != null && permission.getTarget().contains("ask-mode")).filter(permission -> "allow".equals(permission.getEffect())).forEach(permission -> {
                    String id = permission.getId() + "_";
                    Map conditions = permission.getConditions();
                    Object o = conditions.get(permission.getTarget());
                    if (null == o) {
                        return;
                    }
                    JSONObject object = (JSONObject)JsonUtil.toObject((String)o.toString(), JSONObject.class);
                    if (object != null) {
                        object.forEach((key, value) -> jsonObject.put(id + key, (Object)"allow".equals(value)));
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("queryUserJobFunctionPermissions error:\n{}", (Object)e.getMessage(), (Object)e);
        }
        return jsonObject;
    }
}

