/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.controller;

import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.CheckSmartUserRequest;
import com.digiwin.athena.agiledataquery.synonym.domain.CreateSmartUserRequest;
import com.digiwin.athena.agiledataquery.synonym.domain.QuerySmartUserRequest;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.service.SmartUserConfigService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/restful/service/config/smartUser"})
public class SmartUserConfigController {
    private static final Logger log = LoggerFactory.getLogger(SmartUserConfigController.class);
    @Resource
    private SmartUserConfigService smartUserConfigService;

    @PostMapping(value={"/check"})
    public Object checkUser(@RequestBody CheckSmartUserRequest request) {
        return this.smartUserConfigService.checkUser(request);
    }

    @PostMapping(value={"/getList"})
    public Object getList(@RequestBody QuerySmartUserRequest request) {
        return this.smartUserConfigService.findList(request);
    }

    @PostMapping(value={"/create"})
    public Object create(@RequestBody CreateSmartUserRequest request) {
        AthenaUser user = AthenaUserLocal.getUser();
        if (null != user) {
            request.getConfigList().forEach(config -> config.setCreateBy((Object)user.getUserName()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getTenantId())) {
            request.getConfigList().forEach(config -> config.setTenantId(request.getTenantId()));
        }
        this.smartUserConfigService.saveAll(request.getConfigList());
        return null;
    }

    @PostMapping(value={"/delete"})
    public Object delete(@RequestBody DeleteVo request) {
        this.smartUserConfigService.delete(request);
        return null;
    }

    @GetMapping(value={"/getUserList"})
    public Object getUserList(String tenantId, String keyWord) {
        return this.smartUserConfigService.queryUserInTenant(tenantId, keyWord);
    }
}

