/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.enums.NewSourceType;
import com.digiwin.athena.agiledataquery.synonym.domain.BusinessVariables;
import com.digiwin.athena.agiledataquery.synonym.domain.BusinessVariablesValue;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.Pair;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class BusinessVariablesValueDao {
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoTemplate systemMongoTemplate;

    public PageVo<BusinessVariablesValue> getPage(String appCode, String tid, int pageNum, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        --pageNum;
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        criteria.and("appCode").is((Object)appCode);
        criteria.and("source").ne((Object)NewSourceType.SYSTEM.getCode());
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"data_name"});
        long totalCount = this.mongoTemplate.count(query, BusinessVariablesValue.class);
        List entityTypes = this.mongoTemplate.find(query.with((Pageable)pageable), BusinessVariablesValue.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, entityTypes, pageNum, pageSize, totalPage);
    }

    public void update(BusinessVariablesValue businessVariablesValue) {
        if (businessVariablesValue == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)businessVariablesValue.getSource())) {
            businessVariablesValue.setSource(NewSourceType.CUSTOM.getCode());
        }
        this.mongoTemplate.save((Object)businessVariablesValue);
    }

    public List<BusinessVariablesValue> queryBusinessVariablesValue(String tid, String appCode) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tid)});
        criteria.and("appCode").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, BusinessVariablesValue.class);
    }

    public List<BusinessVariables> queryBusinessVariables(String appCode, String tenantVersion) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"version").is((Object)tenantVersion)});
        criteria.and("appCode").is((Object)appCode);
        query.addCriteria((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, BusinessVariables.class);
    }

    public void deleteBusinessVariables(DeleteVo deleteVo) {
        if (StringUtils.isEmpty((CharSequence)deleteVo.getTid())) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)deleteVo.getTid());
        criteria.and("appCode").is((Object)deleteVo.getAppCode());
        if (!CollectionUtils.isEmpty((Collection)deleteVo.getIds())) {
            criteria.and("id").in((Collection)deleteVo.getIds());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, BusinessVariablesValue.class);
    }

    public void insertBusinessVariables(List<BusinessVariablesValue> businessVariables) {
        this.mongoTemplate.insertAll(businessVariables);
    }

    public List<BusinessVariablesValue> queryAll() {
        Query query = new Query();
        Criteria criteria = new Criteria();
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, BusinessVariablesValue.class);
    }

    public void saveBusinessVariables(List<BusinessVariablesValue> list) {
        ArrayList updateList = new ArrayList(list.size());
        BulkOperations operations = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, "agiledata_business_variables_value");
        list.forEach(data -> {
            Query query = new Query((CriteriaDefinition)new Criteria("_id").is((Object)data.getId()));
            Update update = new Update();
            update.set("source", (Object)data.getSource());
            Pair updatePair = Pair.of((Object)query, (Object)update);
            updateList.add(updatePair);
        });
        operations.upsert(updateList);
        operations.execute();
    }
}

