/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.synonym.domain.SmartUserConfig;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SmartUserConfigRest {
    private static final Logger log = LoggerFactory.getLogger(SmartUserConfigRest.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;

    public void saveAll(List<SmartUserConfig> configs) {
        if (CollectionUtils.isEmpty(configs)) {
            return;
        }
        List collect = configs.stream().map(SmartUserConfig::getId).collect(Collectors.toList());
        this.delete(collect);
        configs.forEach(config -> config.setCreateDate(new Date()));
        this.mongoTemplate.insertAll(configs);
    }

    public List<SmartUserConfig> findList(String tenantId, String userId, String keyWord, List<String> ids) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"userId").regex(keyWord), Criteria.where((String)"userName").regex(keyWord)});
        }
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            criteria.and("userId").is((Object)userId);
        }
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.and("id").in(ids);
        }
        query.addCriteria((CriteriaDefinition)criteria).with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate"}));
        return this.mongoTemplate.find(query, SmartUserConfig.class);
    }

    public void delete(List<String> ids) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(ids)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(ids));
        this.mongoTemplate.remove(query, SmartUserConfig.class);
    }
}

