/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.model.dataSubscription.DataSubscriptionRule;
import com.digiwin.athena.agiledataquery.service.impl.DataSubscriptionServiceImpl;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.Subscription;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.synonym.dto.GetSubscriptionByPageRequest;
import com.digiwin.athena.agiledataquery.synonym.util.DateUtil;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class SubscriptionDao {
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    private DataSubscriptionServiceImpl dataSubscriptionService;

    public void createEntry(Subscription subscription) {
        if (subscription == null) {
            return;
        }
        subscription.setCreateDate(DateUtil.getStringDate((Date)new Date()));
        this.mongoTemplate.insert((Object)subscription);
    }

    public void updateEntry(Subscription subscription) {
        if (subscription == null) {
            return;
        }
        subscription.setEditDate(DateUtil.getStringDate((Date)new Date()));
        this.mongoTemplate.save((Object)subscription);
    }

    public PageVo<Subscription> getEntryPage(GetSubscriptionByPageRequest request) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)request.getTenantId())) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        int pageSize = request.getPageSize();
        if (request.getPageSize() == 0) {
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)request.getTenantId()).and("type").is((Object)"entry")});
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getQuestion())) {
            Pattern questionPattern = Pattern.compile("^.*" + request.getQuestion() + ".*$", 2);
            criteria.and("question.question").regex(questionPattern);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)request.getPage(), (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate", "_id"});
        long totalCount = this.mongoTemplate.count(query, Subscription.class);
        List subscriptionList = this.mongoTemplate.find(query.with((Pageable)pageable), Subscription.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, subscriptionList, request.getPage(), pageSize, totalPage);
    }

    public void editSubscription(Subscription subscription) {
    }

    public PageVo<Subscription> getSubscriptionPage(GetSubscriptionByPageRequest request) {
        Pattern patternDesc;
        String tenantId = request.getTenantId();
        Integer pageSize = request.getPageSize();
        Integer pageNum = request.getPage();
        String question = request.getQuestion();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pageSize == 0) {
            pageSize = 10;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)"subscription")});
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)question)) {
            Pattern questionPattern = Pattern.compile("^.*" + question + ".*$", 2);
            criteria.and("question.question").regex(questionPattern);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getCreateDateStart()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getCreateDateEnd())) {
            criteria.and("createDate").gte((Object)request.getCreateDateStart()).lte((Object)request.getCreateDateEnd());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getEditDateStart()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getEditDateEnd())) {
            criteria.and("editDate").gte((Object)request.getEditDateStart()).lte((Object)request.getEditDateEnd());
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getCreateBy())) {
            patternDesc = Pattern.compile("^.*" + request.getCreateBy() + ".*$", 2);
            criteria.and("createBy").regex(patternDesc);
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getEditBy())) {
            patternDesc = Pattern.compile("^.*" + request.getEditBy() + ".*$", 2);
            criteria.and("editBy").regex(patternDesc);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize, (Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createDate", "_id"});
        long totalCount = this.mongoTemplate.count(query, Subscription.class);
        List subscriptionList = this.mongoTemplate.find(query.with((Pageable)pageable), Subscription.class);
        int totalPage = (int)(totalCount % (long)pageSize.intValue() == 0L ? totalCount / (long)pageSize.intValue() : totalCount / (long)pageSize.intValue() + 1L);
        return new PageVo((int)totalCount, subscriptionList, pageNum.intValue(), pageSize.intValue(), totalPage);
    }

    public void deleteEntry(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            return;
        }
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)AthenaUserLocal.getUser().getTenantId()).and("code").is((Object)code)), Subscription.class);
    }

    public Subscription getEntryDetail(String code) {
        if (StringUtils.isEmpty((Object)code)) {
            throw new DWBusinessException("code \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (Subscription)this.mongoTemplate.findOne(new Query((CriteriaDefinition)Criteria.where((String)"code").is((Object)code)), Subscription.class);
    }

    public List<DataSubscriptionRule> querySubscription(String tenantId, String userId) {
        return this.dataSubscriptionService.postQueryDataSubscriptionConfig(tenantId, userId, "", "", null, null, "asada");
    }

    public List<Subscription> findByQuestion(String tenantId, String question) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("type").is((Object)"subscription").and("question.question").is((Object)question)), Subscription.class);
    }

    public Subscription fineOne(Query query) {
        return (Subscription)this.mongoTemplate.findOne(query, Subscription.class);
    }

    public void insertOne(Subscription subscription) {
        this.mongoTemplate.insert((Object)subscription);
    }

    public void deleteSubscription(String tenantId, List<String> ruleIds) {
        this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)tenantId).and("code").in(ruleIds)), Subscription.class);
    }
}

