/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dao;

import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class SynonymRest {
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;

    public void insertOrUpdate(Synonym synonym) {
        if (synonym == null) {
            return;
        }
        synonym.setEditDate(new Date());
        this.mongoTemplate.save((Object)synonym);
    }

    public void saveAll(List<Synonym> synonyms) {
        if (CollectionUtils.isEmpty(synonyms)) {
            return;
        }
        List collect = synonyms.stream().map(Synonym::getObjectId).collect(Collectors.toList());
        this.delete(collect);
        this.insertAll(synonyms);
    }

    private void delete(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(list));
        this.mongoTemplate.remove(query, Synonym.class);
    }

    public PageVo findListPage(String tenantId, String properNoun, String entityTypeName, String des, int page, int pageSize) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)des)) {
            criteria.and("description").regex(des);
        }
        if (StringUtils.isNotEmpty((CharSequence)properNoun)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"properNoun").regex(properNoun), Criteria.where((String)"zh_CN_Str").regex(properNoun), Criteria.where((String)"zh_TW_Str").regex(properNoun)});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.and("entityTypeName").regex(entityTypeName);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        long totalCount = this.mongoTemplate.count(query, Synonym.class);
        List synonyms = this.mongoTemplate.find(query.with((Pageable)pageable), Synonym.class);
        int totalPage = (int)(totalCount % (long)pageSize == 0L ? totalCount / (long)pageSize : totalCount / (long)pageSize + 1L);
        return new PageVo((int)totalCount, synonyms, page, pageSize, totalPage);
    }

    public List<Synonym> findList(String tenantId, String properNoun, String entityTypeName, String des) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (StringUtils.isNotEmpty((CharSequence)des)) {
            criteria.and("description").regex(des);
        }
        if (StringUtils.isNotEmpty((CharSequence)properNoun)) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"properNoun").regex(properNoun), Criteria.where((String)"zh_CN_Str").regex(properNoun), Criteria.where((String)"zh_TW_Str").regex(properNoun)});
        }
        if (StringUtils.isNotEmpty((CharSequence)entityTypeName)) {
            criteria.and("entityTypeName").regex(entityTypeName);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Synonym.class);
    }

    public List<Synonym> findList(String tenantId, List<String> ids) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(ids)) {
            PageVo listPage = this.findListPage(tenantId, null, null, null, 0, 5000);
            int totalPage = listPage.getTotalPage();
            if (totalPage <= 1) {
                return listPage.getList();
            }
            List list = listPage.getList();
            for (int i = 1; i < totalPage; ++i) {
                PageVo page = this.findListPage(tenantId, null, null, null, i, 5000);
                list.addAll(page.getList());
            }
            return list;
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        if (!CollectionUtils.isEmpty(ids)) {
            criteria.and("_id").in(ids);
        }
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, Synonym.class);
    }

    public List<Synonym> findAll(int page, int pageSize) {
        PageRequest pageable = PageRequest.of((int)page, (int)pageSize);
        return this.mongoTemplate.find(new Query().with((Pageable)pageable), Synonym.class);
    }

    public Synonym findOne(String tenantId, String entityTypeName, String properNoun) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.and("tenantId").is((Object)tenantId).and("properNoun").is((Object)properNoun).and("entityTypeName").is((Object)entityTypeName);
        query.addCriteria((CriteriaDefinition)criteria);
        return (Synonym)this.mongoTemplate.findOne(query, Synonym.class);
    }

    public void delete(List<String> list, String tenantId) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in(list).andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)}));
        this.mongoTemplate.remove(query, Synonym.class);
    }

    public void insertAll(List<Synonym> synonyms) {
        this.mongoTemplate.insertAll(synonyms);
    }

    public Map<String, Integer> groupByEntityCount(String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        MatchOperation matchOperation = Aggregation.match((Criteria)Criteria.where((String)"tenantId").is((Object)tenantId));
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{"entityTypeName"}).count().as("count");
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation});
        AggregationResults results = this.mongoTemplate.aggregate(aggregation, "synonym", Map.class);
        List mappedResults = results.getMappedResults();
        if (CollectionUtils.isEmpty((Collection)mappedResults)) {
            return new HashMap<String, Integer>();
        }
        for (Map mappedResult : mappedResults) {
            result.put(mappedResult.get("_id").toString(), (Integer)mappedResult.get("count"));
        }
        return result;
    }
}

