/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dataSync.dao;

import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.EntityTypeConfig;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.LocalAppInfo;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SyncAppInfoDao {
    private static final Logger log = LoggerFactory.getLogger(SyncAppInfoDao.class);
    @Autowired
    @Qualifier(value="mongoTemplateTenant")
    private MongoTemplate mongoTemplate;
    @Autowired
    private MongoTemplate systemMongoTemplate;

    public void insertLocalAll(List<LocalAppInfo> localAppInfos) {
        AthenaUser user = AthenaUserLocal.getUser();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(localAppInfos)) {
            for (LocalAppInfo localAppInfo : localAppInfos) {
                localAppInfo.setUserEmail(user.getUserId());
            }
        }
        this.mongoTemplate.insertAll(localAppInfos);
    }

    public void saveLocalAll(List<LocalAppInfo> localAppInfos) {
        Map uniqueInfos = localAppInfos.stream().filter(info -> info.getObjectId() != null).collect(Collectors.toMap(LocalAppInfo::getObjectId, Function.identity(), (existing, replacement) -> existing));
        BulkOperations bulkOps = this.mongoTemplate.bulkOps(BulkOperations.BulkMode.ORDERED, LocalAppInfo.class);
        uniqueInfos.values().forEach(info -> {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)info.getObjectId()));
            Document doc = new Document();
            this.mongoTemplate.getConverter().write(info, (Object)doc);
            doc.remove((Object)"_id");
            Update update = new Update();
            doc.forEach((key, value) -> update.set(key, value));
            bulkOps.upsert(query, update);
        });
        bulkOps.execute();
    }

    public void saveEntityAll(List<EntityTypeConfig> entityTypeConfigs) {
        List collect = entityTypeConfigs.stream().map(EntityTypeConfig::getId).collect(Collectors.toList());
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").in(collect));
        this.systemMongoTemplate.remove(query, EntityTypeConfig.class);
        this.systemMongoTemplate.insertAll(entityTypeConfigs);
    }

    public void deleteLocal(DeleteVo deleteVo) {
        if (CollectionUtils.isEmpty((Collection)deleteVo.getIds())) {
            return;
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"objectId").in((Collection)deleteVo.getIds()));
        this.mongoTemplate.remove(query, LocalAppInfo.class);
    }

    public void deleteEntityConfig(String appName, String appType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"appName").is((Object)appName).and("appType").is((Object)appType)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.systemMongoTemplate.remove(query, EntityTypeConfig.class);
    }

    public List<LocalAppInfo> findLocalListPage(String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query();
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"tenantId").is((Object)tenantId)});
        query.addCriteria((CriteriaDefinition)criteria);
        return this.mongoTemplate.find(query, LocalAppInfo.class);
    }

    public List<EntityTypeConfig> findEntityConfigList(String appName, String appType) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"appName").is((Object)appName).and("appType").is((Object)appType)});
        Query query = new Query((CriteriaDefinition)criteria);
        return this.systemMongoTemplate.find(query, EntityTypeConfig.class);
    }

    public void updateLocal(LocalAppInfo localAppInfo) {
        if (localAppInfo == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)localAppInfo.getObjectId())) {
            throw new DWBusinessException("\u5f53\u524d\u6570\u636e\u65e0id" + localAppInfo.toString());
        }
        this.mongoTemplate.save((Object)localAppInfo);
    }

    public List<LocalAppInfo> getAll() {
        return this.mongoTemplate.findAll(LocalAppInfo.class);
    }

    public LocalAppInfo findLocal(String id) {
        return (LocalAppInfo)this.mongoTemplate.findById((Object)id, LocalAppInfo.class);
    }

    public void saveEntity(EntityTypeConfig entityTypeConfig) {
        if (entityTypeConfig == null) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)entityTypeConfig.getId())) {
            throw new DWBusinessException("\u5f53\u524d\u6570\u636e\u65e0id" + entityTypeConfig.toString());
        }
        this.systemMongoTemplate.save((Object)entityTypeConfig);
    }
}

