/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.dataSync.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.synonym.dataSync.dao.SyncAppInfoDao;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.EntityTypeConfig;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.LocalAppInfo;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.po.AgileDataAppInfo;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.po.CloudAppData;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.po.OnPremAppData;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.po.SynonymsValue;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.vo.AppInfoVo;
import com.digiwin.athena.agiledataquery.synonym.dataSync.service.SyncAppInfoService;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.http.OperatePlatformApiServiceHelper;
import com.digiwin.athena.agiledataquery.synonym.util.RestUtil;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SyncAppInfoServiceImpl
implements SyncAppInfoService {
    private static final Logger log = LoggerFactory.getLogger(SyncAppInfoServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SyncAppInfoDao syncAppInfoDao;
    @Autowired
    private Scheduler scheduler;
    public static final String CHATBI = "ChatBI";
    private static final String localUrl = "/api/ddl/valid/app/setting/by/map";
    public static final String agileUrl = "/platform/product/all";
    public static final String agileValueUrl = "/platform/value/getList";
    public static final String cacUrl = "/api/cac/v4/authorizations/current/simple";
    private static final String TOKEN_URL = "/api/iam/v2/identity/login/internal";
    public static final String IAM_USER = "integration";
    public static final String IAM_PASSWORD = "6826CC688C4AF1BD0A8DDA2DBDF8897B";
    @Value(value="${rest-url.dcdpinteract}")
    private String dcdpinteract;
    @Value(value="${cacUrl}")
    private String cac;
    @Value(value="${iamApToken}")
    private String appToken;
    @Autowired
    private OperatePlatformApiServiceHelper operatePlatformApiServiceHelper;
    public static final String ONPREM = "ONPREM";
    public static final String CLOUD = "CLOUD";
    @Value(value="${iamUrl}")
    private String iamUrl;
    @Autowired
    RestTemplate iamRestTemplate;

    public AppInfoVo getLocalAppInfo(String tenantId, boolean syncLocal) {
        List localListPage = this.syncAppInfoDao.findLocalListPage(tenantId);
        AppInfoVo appInfoVo = new AppInfoVo();
        Map effective = this.getEffective(appInfoVo, tenantId);
        ArrayList<LocalAppInfo> result = new ArrayList<LocalAppInfo>();
        List localAppInfos = this.mapToList(effective, tenantId);
        if (CollectionUtils.isEmpty((Collection)localListPage)) {
            ArrayList<LocalAppInfo> lcoals = new ArrayList<LocalAppInfo>();
            ArrayList<LocalAppInfo> clouds = new ArrayList<LocalAppInfo>();
            for (LocalAppInfo localAppInfo : localAppInfos) {
                localAppInfo.setObjectId(UUID.randomUUID().toString());
                if ("ONPREM".equals(localAppInfo.getAppType())) {
                    lcoals.add(localAppInfo);
                    continue;
                }
                if (!"CLOUD".equals(localAppInfo.getAppType())) continue;
                clouds.add(localAppInfo);
            }
            appInfoVo.setLocalAppInfoList(lcoals);
            appInfoVo.setCloudAppInfoList(clouds);
            this.syncAppInfoDao.insertLocalAll(localAppInfos);
            return appInfoVo;
        }
        HashMap<String, LocalAppInfo> localAppInfoMap = new HashMap<String, LocalAppInfo>();
        HashMap<String, LocalAppInfo> cloudAppInfoMap = new HashMap<String, LocalAppInfo>();
        ArrayList<LocalAppInfo> updateList = new ArrayList<LocalAppInfo>();
        ArrayList<LocalAppInfo> insertList = new ArrayList<LocalAppInfo>();
        for (LocalAppInfo localAppInfo : localListPage) {
            localAppInfoMap.put(localAppInfo.getAppType() + "_" + localAppInfo.getAppCode(), localAppInfo);
        }
        for (LocalAppInfo localAppInfo : localAppInfos) {
            cloudAppInfoMap.put(localAppInfo.getAppType() + "_" + localAppInfo.getAppCode(), localAppInfo);
        }
        for (Object s : localAppInfoMap.keySet()) {
            LocalAppInfo localAppInfo = (LocalAppInfo)cloudAppInfoMap.get(s);
            LocalAppInfo localAppInfo1 = (LocalAppInfo)localAppInfoMap.get(s);
            if (localAppInfo == null) {
                localAppInfo1.setEffectiveness(Boolean.valueOf(false));
                updateList.add(localAppInfo1);
            } else {
                localAppInfo1.setAppName(localAppInfo.getAppName());
                localAppInfo1.setEffectiveness(Boolean.valueOf(true));
                updateList.add(localAppInfo1);
            }
            result.add(localAppInfo1);
        }
        Set strings = cloudAppInfoMap.keySet();
        if (CollectionUtils.isNotEmpty(strings)) {
            for (String s : strings) {
                LocalAppInfo localAppInfo = (LocalAppInfo)localAppInfoMap.get(s);
                if (localAppInfo != null) continue;
                LocalAppInfo localAppInfo1 = (LocalAppInfo)cloudAppInfoMap.get(s);
                if (localAppInfo1 != null) {
                    localAppInfo1.setObjectId(UUID.randomUUID().toString());
                }
                insertList.add(localAppInfo1);
                result.add(localAppInfo1);
            }
        }
        if (syncLocal) {
            if (CollectionUtils.isNotEmpty(updateList)) {
                this.syncAppInfoDao.saveLocalAll(updateList);
            }
            if (CollectionUtils.isNotEmpty(insertList)) {
                this.syncAppInfoDao.insertLocalAll(insertList);
            }
        }
        ArrayList<LocalAppInfo> lcoals = new ArrayList<LocalAppInfo>();
        ArrayList<LocalAppInfo> clouds = new ArrayList<LocalAppInfo>();
        for (LocalAppInfo localAppInfo : result) {
            if ("ONPREM".equals(localAppInfo.getAppType())) {
                lcoals.add(localAppInfo);
                continue;
            }
            if (!"CLOUD".equals(localAppInfo.getAppType())) continue;
            clouds.add(localAppInfo);
        }
        appInfoVo.setLocalAppInfoList(lcoals);
        appInfoVo.setCloudAppInfoList(clouds);
        return appInfoVo;
    }

    public List<LocalAppInfo> getLocalAppInfos(String tenantId) {
        AppInfoVo localAppInfo = this.getLocalAppInfo(tenantId, true);
        if (localAppInfo == null) {
            return null;
        }
        ArrayList<LocalAppInfo> result = new ArrayList<LocalAppInfo>();
        if (CollectionUtils.isNotEmpty((Collection)localAppInfo.getCloudAppInfoList())) {
            result.addAll(localAppInfo.getCloudAppInfoList());
        }
        if (CollectionUtils.isNotEmpty((Collection)localAppInfo.getLocalAppInfoList())) {
            result.addAll(localAppInfo.getLocalAppInfoList());
        }
        return result;
    }

    public void updateLocalAppInfo(LocalAppInfo localAppInfo) {
        this.syncEntitySwitch(localAppInfo);
        this.syncAppInfoDao.updateLocal(localAppInfo);
    }

    private void syncEntitySwitch(LocalAppInfo localAppInfo) {
        List entityConfigList = this.syncAppInfoDao.findEntityConfigList(localAppInfo.getAppName(), localAppInfo.getAppType());
        if (CollectionUtils.isEmpty((Collection)entityConfigList)) {
            return;
        }
        for (EntityTypeConfig entityTypeConfig : entityConfigList) {
            entityTypeConfig.setEntitySwitch(localAppInfo.getAppSwitch());
        }
        this.syncAppInfoDao.saveEntityAll(entityConfigList);
    }

    private List<AgileDataAppInfo> getAppStatement(AppInfoVo appInfoVo) {
        return new ArrayList<AgileDataAppInfo>();
    }

    private List<SynonymsValue> getAgileValues(String appName, String appType) {
        return new ArrayList<SynonymsValue>();
    }

    private List<OnPremAppData> getRPCLocalAppInfo(AppInfoVo appInfoVo, String token, String tid) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("deviceAppType", (Object)"ChatBI");
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.postForEntity(this.dcdpinteract + "/api/ddl/valid/app/setting/by/map", (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)result.getBody();
        if (body != null) {
            JSONObject o;
            JSONArray data = body.getJSONArray("data");
            String string = body.getString("code");
            if (!"0".equals(string)) {
                throw new DWBusinessException(body.getString("errorMsg"));
            }
            if (data != null && !data.isEmpty() && (o = data.getJSONObject(0)) != null) {
                if ("multiple".equals(o.getString("chatBIMode"))) {
                    JSONArray jsonArray = o.getJSONArray("ChatBIInstanceList");
                    if (jsonArray != null) {
                        List javaList = jsonArray.toJavaList(OnPremAppData.class);
                        if (CollectionUtils.isNotEmpty((Collection)javaList)) {
                            for (OnPremAppData onPremAppData : javaList) {
                                onPremAppData.setTenantId(tid);
                            }
                        }
                        if (appInfoVo != null) {
                            appInfoVo.setOnPremAppDataList(javaList);
                        }
                        return javaList;
                    }
                } else {
                    OnPremAppData single = new OnPremAppData();
                    single.setChatBIInstanceInfo(o.getString("chatBIInstanceInfo"));
                    single.setChatBIProductCode(o.getString("chatBIProductCode"));
                    return Collections.singletonList(single);
                }
            }
        }
        return null;
    }

    private List<CloudAppData> getRPCCloudAppInfo(AppInfoVo appInfoVo, String token) {
        JSONObject data;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", this.appToken);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("queryExpire", (Object)0);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
        ResponseEntity result = this.restTemplate.postForEntity(this.cac + "/api/cac/v4/authorizations/current/simple", (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)result.getBody();
        if (body != null && (data = body.getJSONObject("data")) != null) {
            JSONArray jsonArray = data.getJSONArray("authorizations");
            List javaList = jsonArray.toJavaList(CloudAppData.class);
            if (appInfoVo != null) {
                appInfoVo.setCloudAppDataList(javaList);
            }
            return javaList;
        }
        return null;
    }

    private LocalAppInfo agileDataAppInfoToLocalAppInfo(AgileDataAppInfo agileDataAppInfo, String tenantId) {
        LocalAppInfo localAppInfo = new LocalAppInfo();
        localAppInfo.setAppCode(agileDataAppInfo.getProductCode());
        localAppInfo.setAppName(agileDataAppInfo.getProductName());
        localAppInfo.setAppType(agileDataAppInfo.getProductType());
        localAppInfo.setTenantId(tenantId);
        return localAppInfo;
    }

    private List<LocalAppInfo> mapToList(Map<String, Map<String, AgileDataAppInfo>> agileDataAppInfos, String tenantId) {
        LocalAppInfo localAppInfo;
        AgileDataAppInfo value;
        Map<String, AgileDataAppInfo> cloud = agileDataAppInfos.get("CLOUD");
        Map<String, AgileDataAppInfo> local = agileDataAppInfos.get("ONPREM");
        ArrayList<LocalAppInfo> localList = new ArrayList<LocalAppInfo>();
        if (cloud != null) {
            for (Map.Entry<String, AgileDataAppInfo> appInfoEntry : cloud.entrySet()) {
                value = appInfoEntry.getValue();
                localAppInfo = this.agileDataAppInfoToLocalAppInfo(value, tenantId);
                localList.add(localAppInfo);
            }
        }
        if (local != null) {
            for (Map.Entry<String, AgileDataAppInfo> appInfoEntry : local.entrySet()) {
                value = appInfoEntry.getValue();
                localAppInfo = this.agileDataAppInfoToLocalAppInfo(value, tenantId);
                localList.add(localAppInfo);
            }
        }
        return localList;
    }

    private Map<String, Map<String, AgileDataAppInfo>> getEffective(AppInfoVo appInfoVo, String tenantId) {
        List rpcCloudAppInfo;
        List agileDataAppInfos = this.getAppStatement(appInfoVo);
        HashMap<String, Map<String, AgileDataAppInfo>> result = new HashMap<String, Map<String, AgileDataAppInfo>>();
        if (CollectionUtils.isEmpty((Collection)agileDataAppInfos)) {
            return result;
        }
        HashMap<String, AgileDataAppInfo> map = new HashMap<String, AgileDataAppInfo>();
        for (AgileDataAppInfo agileDataAppInfo : agileDataAppInfos) {
            map.put(agileDataAppInfo.getProductType() + "_" + agileDataAppInfo.getProductCode(), agileDataAppInfo);
        }
        String token = this.getToken(tenantId);
        List rpcLocalAppInfo = this.getRPCLocalAppInfo(appInfoVo, token, tenantId);
        if (!CollectionUtils.isEmpty((Collection)rpcLocalAppInfo)) {
            HashMap<String, AgileDataAppInfo> localCodeMap = new HashMap<String, AgileDataAppInfo>();
            for (OnPremAppData onPremAppData : rpcLocalAppInfo) {
                String chatBIProductCode = onPremAppData.getChatBIProductCode();
                AgileDataAppInfo agileDataAppInfo = (AgileDataAppInfo)map.get("ONPREM_" + chatBIProductCode);
                if (agileDataAppInfo == null) continue;
                localCodeMap.put(chatBIProductCode, agileDataAppInfo);
            }
            result.put("ONPREM", localCodeMap);
        }
        if (!CollectionUtils.isEmpty((Collection)(rpcCloudAppInfo = this.getRPCCloudAppInfo(appInfoVo, token)))) {
            HashMap<String, AgileDataAppInfo> cloudMap = new HashMap<String, AgileDataAppInfo>();
            for (CloudAppData cloudAppData : rpcCloudAppInfo) {
                String chatBIProductCode = cloudAppData.getCode();
                AgileDataAppInfo agileDataAppInfo = (AgileDataAppInfo)map.get("CLOUD_" + chatBIProductCode);
                if (agileDataAppInfo == null) continue;
                cloudMap.put(chatBIProductCode, agileDataAppInfo);
            }
            result.put("CLOUD", cloudMap);
        }
        return result;
    }

    public String getToken(String tenantId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("tenantId", (Object)tenantId);
        jsonObject.put("userId", (Object)"integration");
        jsonObject.put("passwordHash", (Object)"6826CC688C4AF1BD0A8DDA2DBDF8897B");
        HttpHeaders headers = RestUtil.getHeaders();
        headers.add("digi-middleware-auth-app", this.appToken);
        HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
        ResponseEntity result = this.iamRestTemplate.postForEntity(this.iamUrl + "/api/iam/v2/identity/login/internal", (Object)httpEntity, JSONObject.class, new Object[0]);
        JSONObject body = (JSONObject)result.getBody();
        if (body != null) {
            String string = body.getString("token");
            return string;
        }
        return null;
    }

    public void delete(LocalAppInfo localAppInfo) {
        if (localAppInfo == null || localAppInfo.getEffectiveness().booleanValue()) {
            throw new DWBusinessException("\u5220\u9664\u5931\u8d25\uff0c\u5f53\u524d\u5e94\u7528\u5df2\u88ab\u5220\u9664\u6216\u8005\u4ecd\u7136\u751f\u6548\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        DeleteVo deleteVo = new DeleteVo();
        ArrayList<String> list = new ArrayList<String>();
        list.add(localAppInfo.getObjectId());
        deleteVo.setIds(list);
        String groupName = localAppInfo.getTenantId();
        String jobIdPrefix = "system_" + localAppInfo.getTenantId() + "_" + localAppInfo.getAppType() + "_" + localAppInfo.getAppCode();
        try {
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)groupName))) {
                if (!jobKey.getName().contains(jobIdPrefix)) continue;
                this.scheduler.deleteJob(jobKey);
                log.info("\u4efb\u52a1\u5220\u9664\u6210\u529f,jobKeyName:{}", (Object)jobKey.getName());
            }
        }
        catch (SchedulerException e) {
            log.error("\u4efb\u52a1\u5220\u9664\u5931\u8d25,{}", (Object)e.getMessage());
        }
        this.syncAppInfoDao.deleteLocal(deleteVo);
    }

    public List<EntityTypeConfig> getEntityList(String appName, String appType) {
        List agileValues = this.getAgileValues(appName, appType);
        if (CollectionUtils.isEmpty((Collection)agileValues)) {
            this.syncAppInfoDao.deleteEntityConfig(appName, appType);
            return new ArrayList<EntityTypeConfig>();
        }
        List entityConfigList = this.syncAppInfoDao.findEntityConfigList(appName, appType);
        List entityTypeConfigs = SyncAppInfoServiceImpl.buildEntityTypeConfigList((List)agileValues);
        if (CollectionUtils.isEmpty((Collection)entityConfigList)) {
            this.syncAppInfoDao.saveEntityAll(entityTypeConfigs);
            return entityTypeConfigs;
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (EntityTypeConfig entityTypeConfig : entityConfigList) {
            map.put(entityTypeConfig.getEntityTypeName(), entityTypeConfig.getEntitySwitch());
        }
        for (EntityTypeConfig entityTypeConfig : entityTypeConfigs) {
            entityTypeConfig.setEntitySwitch((Boolean)map.get(entityTypeConfig.getEntityTypeName()));
        }
        this.syncAppInfoDao.deleteEntityConfig(appName, appType);
        this.syncAppInfoDao.saveEntityAll(entityTypeConfigs);
        return entityTypeConfigs;
    }

    public void updateEntityConfig(EntityTypeConfig entityTypeConfig) {
        this.syncAppInfoDao.saveEntity(entityTypeConfig);
    }

    public LocalAppInfo getLocalDetail(String id) {
        return this.syncAppInfoDao.findLocal(id);
    }

    private static List<EntityTypeConfig> buildEntityTypeConfigList(List<SynonymsValue> synonymsValues) {
        ArrayList<EntityTypeConfig> entityTypeConfigList = new ArrayList<EntityTypeConfig>();
        for (SynonymsValue synonymsValue : synonymsValues) {
            EntityTypeConfig entityTypeConfig = new EntityTypeConfig();
            entityTypeConfig.setEntitySwitch(Boolean.valueOf(true));
            entityTypeConfig.setEntityTypeName(synonymsValue.getEntityType());
            entityTypeConfig.setAppType(synonymsValue.getProductType());
            entityTypeConfig.setAppName(synonymsValue.getProductName());
            entityTypeConfig.setLang(synonymsValue.getLang());
            String string = UUID.randomUUID().toString();
            entityTypeConfig.setId(string);
            entityTypeConfigList.add(entityTypeConfig);
        }
        return entityTypeConfigList;
    }
}

