/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.http;

import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class DcdpinteractApiHelper {
    private static final Logger log = LoggerFactory.getLogger(DcdpinteractApiHelper.class);
    @Value(value="${rest-url.dcdpinteract}")
    private String dcdpinteractUrl;
    @Autowired
    private RestTemplate restTemplate;

    public JSONObject getDataBySql(JSONObject reqBody, String token) {
        String url = this.dcdpinteractUrl + "/api/ddl/execute/and/return";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        HttpEntity httpEntity = new HttpEntity((Object)reqBody, (MultiValueMap)headers);
        log.info("\u8c03\u5730\u7aef\u83b7\u53d6\u6570\u636e\u5730\u5740\u4e3a\uff1a" + url);
        ResponseEntity result = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        int statusCodeValue = result.getStatusCodeValue();
        if (statusCodeValue != 200) {
            log.info("\u8c03\u5730\u7aef\u83b7\u53d6\u6570\u636e\u5931\u8d25");
            return new JSONObject();
        }
        JSONObject body = (JSONObject)result.getBody();
        if (Objects.isNull(body)) {
            log.info("\u8c03\u5730\u7aef\u83b7\u53d6\u6570\u636ebody\u4e3a\u7a7a");
            return new JSONObject();
        }
        JSONObject data = body.getJSONObject("data");
        if (Objects.isNull(data)) {
            log.info("\u8c03\u5730\u7aef\u83b7\u53d6\u6570\u636edata\u4e3a\u7a7a");
            return new JSONObject();
        }
        JSONObject detail = data.getJSONObject("detail");
        if (Objects.isNull(detail)) {
            log.info("\u8c03\u5730\u7aef\u83b7\u53d6\u6570\u636edetail\u4e3a\u7a7a");
            return new JSONObject();
        }
        return detail;
    }
}

