/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.http;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.TenantUserResult;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class IamServiceApiHelper {
    private static final Logger log = LoggerFactory.getLogger(IamServiceApiHelper.class);
    private static final String queryAllTenantUser = "/api/iam/v2/tenant/user/list";
    private static final String queryRolesInTenant = "/api/iam/v2/role/simple";
    @Autowired
    private IamService iamService;
    @Value(value="${iamApToken}")
    private String appToken;
    @Value(value="${iamUrl}")
    private String iamUrl;

    public TenantUserResult queryUserInTenant(String tenantId, String token, Integer pageSize, Integer pageNum) {
        String param = String.format("?pageSize=%d&pageNum=%d", pageSize, pageNum);
        String queryUserInTenantsUrl = queryAllTenantUser + param;
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        this.addParamToQueryUser(token, paramJson);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).body(paramJson.toJSONString()).execute().body();
        try {
            JSONObject responseObj = JSON.parseObject((String)response);
            List users = responseObj.getJSONArray("list").toJavaList(JSONObject.class);
            Integer total = responseObj.getInteger("total");
            return new TenantUserResult().setUserList(users).setTotal(total);
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25:{}", (Object)response);
            throw new DWBusinessException(responseObj.getString("errorMessage"));
        }
    }

    public JSONArray queryRolesInTenant() {
        String token = AthenaUserLocal.getUser().getToken();
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createGet((String)(this.iamUrl + queryRolesInTenant)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", token)).body("{}").execute().body();
        try {
            return JSON.parseArray((String)response);
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u89d2\u8272\u5931\u8d25:{}", (Object)response);
            throw new DWBusinessException(responseObj.getString("errorMessage"));
        }
    }

    public String getIntegrationToken(String tenantId) {
        Object login;
        try {
            login = this.iamService.login(tenantId);
        }
        catch (Exception e) {
            throw new DWBusinessException("iam\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
        String token = null;
        if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
            token = loginJsonObject.getString("token");
        }
        return token;
    }

    private void addParamToQueryUser(String token, JSONObject paramJson) {
        String isvCode = this.getIsvCode(token);
        if (StrUtil.isEmpty((CharSequence)isvCode)) {
            paramJson.put("searchType", (Object)1);
        }
    }

    private String getIsvCode(String token) {
        String tbbServiceUrl = this.iamUrl + "/api/iam/v2/tenant/current";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", token);
        headers.put("digi-middleware-auth-app", this.appToken);
        String response = ((HttpRequest)HttpUtil.createPost((String)tbbServiceUrl).addHeaders(headers)).execute().body();
        JSONObject reponseJson = JSON.parseObject((String)response);
        return reponseJson.getJSONObject("tenant").getString("customerId");
    }
}

