/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.http;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class OperatePlatformApiServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(OperatePlatformApiServiceHelper.class);
    @Value(value="${rest-url.agiledata}")
    private String agiledataUrl;
    @Value(value="${iamApToken}")
    private String appToken;
    @Autowired
    private RestTemplate restTemplate;

    public JSONObject apiInvoke(HttpMethod method, String request, String path, String iamToken) {
        ResponseEntity exchange;
        String url = this.agiledataUrl + path;
        HttpHeaders headers = new HttpHeaders();
        headers.add("iamToken", iamToken);
        headers.add("appToken", this.appToken);
        Map requestMap = (Map)JSONObject.parseObject((String)request, Map.class);
        if (method.matches("GET")) {
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            exchange = this.restTemplate.exchange(url, method, requestEntity, JSONObject.class, requestMap);
        } else {
            HttpEntity requestEntity = new HttpEntity((Object)requestMap, (MultiValueMap)headers);
            exchange = this.restTemplate.exchange(url, method, requestEntity, JSONObject.class, new Object[0]);
        }
        JSONObject body = (JSONObject)exchange.getBody();
        if (Objects.nonNull(body) && !body.isEmpty() && body.getInteger("code") == 200) {
            return body;
        }
        log.info("\u8c03\u654f\u6377\u6570\u636e\u8fd0\u8425\u5e73\u53f0\u63a5\u53e3\u5931\u8d25");
        return null;
    }
}

