/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.domain.app.Application;
import com.digiwin.athena.agiledataquery.service.ITenantService;
import com.digiwin.athena.agiledataquery.synonym.dao.AppThresholdConfigDao;
import com.digiwin.athena.agiledataquery.synonym.domain.AppThresholdConfig;
import com.digiwin.athena.agiledataquery.synonym.service.AppThresholdConfigService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AppThresholdConfigServiceImpl
implements AppThresholdConfigService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private IamService iamService;
    @Autowired
    private AppThresholdConfigDao appThresholdConfigDao;
    public static final String payPerView = "payPerView";
    @Value(value="${app-threshold:100}")
    private Integer appThreshold;
    @Autowired
    private ITenantService tenantService;

    public List<AppThresholdConfig> getAppThresholdConfigs(String code, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<AppThresholdConfig> result = new ArrayList<AppThresholdConfig>();
        ArrayList<AppThresholdConfig> insertList = new ArrayList<AppThresholdConfig>();
        ArrayList<String> appCodes = new ArrayList<String>();
        List applicationList = this.getApplicationList();
        if (CollectionUtils.isEmpty((Collection)applicationList)) {
            this.appThresholdConfigDao.delete(null, tenantId);
            return Collections.emptyList();
        }
        List list = this.appThresholdConfigDao.findList(tenantId, code);
        HashMap<String, AppThresholdConfig> appThresholdConfigMap = new HashMap<String, AppThresholdConfig>();
        for (AppThresholdConfig appThresholdConfig : list) {
            appThresholdConfigMap.put(appThresholdConfig.getAppCode(), appThresholdConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)code)) {
            applicationList = applicationList.stream().filter(x -> code.equals(x.getCode())).collect(Collectors.toList());
        }
        for (Application application : applicationList) {
            AppThresholdConfig appThresholdConfig = (AppThresholdConfig)appThresholdConfigMap.get(application.getCode());
            appCodes.add(application.getCode());
            if (appThresholdConfig != null) {
                String payType = application.getPayType();
                appThresholdConfig.setBillingGoodsId(application.getBillingGoodsId());
                if (appThresholdConfig.getPayType() != null && !appThresholdConfig.getPayType().equals(payType)) {
                    if (payPerView.equals(payType)) {
                        appThresholdConfig.setThreshold(this.appThreshold.intValue());
                        appThresholdConfig.setCountRemind(Boolean.valueOf(true));
                    } else {
                        appThresholdConfig.setThreshold(0);
                        appThresholdConfig.setCountRemind(Boolean.valueOf(false));
                    }
                }
                appThresholdConfig.setPayType(payType);
                this.appThresholdConfigDao.update(appThresholdConfig);
                result.add(appThresholdConfig);
                continue;
            }
            AppThresholdConfig build = this.build(application, tenantId);
            build.setId(UUID.randomUUID().toString());
            insertList.add(build);
            result.add(build);
        }
        if (!CollectionUtils.isEmpty(insertList)) {
            this.appThresholdConfigDao.saveAll(insertList);
        }
        return result;
    }

    public AppThresholdConfig build(Application application, String tenantId) {
        AppThresholdConfig appThresholdConfig = new AppThresholdConfig();
        appThresholdConfig.setAppCode(application.getCode());
        appThresholdConfig.setAppName(application.getName());
        appThresholdConfig.setCountRemind(Boolean.valueOf(false));
        appThresholdConfig.setPayType(application.getPayType());
        appThresholdConfig.setCountRemind(Boolean.valueOf(payPerView.equals(application.getPayType())));
        appThresholdConfig.setThreshold(payPerView.equals(application.getPayType()) ? this.appThreshold : 0);
        appThresholdConfig.setTenantId(tenantId);
        appThresholdConfig.setBillingGoodsId(application.getBillingGoodsId());
        return appThresholdConfig;
    }

    public void saveAppThresholdConfig(AppThresholdConfig appThresholdConfig) {
        if (!payPerView.equals(appThresholdConfig.getPayType())) {
            throw new DWBusinessException("\u975e\u6b21\u6570\u8ba1\u7b97\u65b9\u5f0f\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        if (!appThresholdConfig.getCountRemind().booleanValue()) {
            appThresholdConfig.setThreshold(0);
        }
        if (appThresholdConfig.getCountRemind().booleanValue() && appThresholdConfig.getThreshold() <= 0) {
            throw new DWBusinessException("\u63d0\u9192\u9608\u503c\u4e3a\u6b63\u6574\u6570");
        }
        this.appThresholdConfigDao.update(appThresholdConfig);
    }

    public AppThresholdConfig getOne(String code, String tenantId) {
        try {
            List appThresholdConfigs;
            Object login = this.iamService.login(tenantId);
            JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
            String token = null;
            if (StringUtils.equals((CharSequence)tenantId, (CharSequence)loginJsonObject.getString("tenantId"))) {
                token = loginJsonObject.getString("token");
            }
            if (CollectionUtils.isEmpty((Collection)(appThresholdConfigs = this.getAppThresholdConfigs(code, tenantId)))) {
                return null;
            }
            if (appThresholdConfigs.size() > 1) {
                throw new DWBusinessException("\u5e94\u7528" + code + "\u5b58\u5728\u591a\u6761\u9608\u503c\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
            }
            return (AppThresholdConfig)appThresholdConfigs.get(0);
        }
        catch (Exception e) {
            throw new DWBusinessException(e.getMessage());
        }
    }

    public List<Application> getApplicationList() {
        return this.tenantService.getTenantMetricApplication();
    }
}

