/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.digiwin.athena.agiledataquery.domain.BigScreenViewConfig;
import com.digiwin.athena.agiledataquery.synonym.dao.BigScreenViewConfigDao;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.po.ScreenInfo;
import com.digiwin.athena.agiledataquery.synonym.service.BigScreenViewConfigService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BigScreenViewConfigServiceImpl
implements BigScreenViewConfigService {
    private static final Logger log = LoggerFactory.getLogger(BigScreenViewConfigServiceImpl.class);
    @Autowired
    private BigScreenViewConfigDao bigScreenViewConfigDao;

    public void dataSync(String tenantId, String appCode) throws Exception {
        List screenInfos;
        BigScreenViewConfig custom = this.getCustom(tenantId, appCode);
        if (Objects.isNull(custom)) {
            BigScreenViewConfig init = new BigScreenViewConfig();
            init.setAppCode(appCode);
            init.setTenantId(tenantId);
            init.setFlashFrequency(Integer.valueOf(5));
            init.setPageTurningFrequency(Integer.valueOf(30));
            AthenaUser user = AthenaUserLocal.getUser();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            init.setUpdateTime(sdf.format(new Date()));
            init.setUpdateUser(user.getUserName());
            init.setType("custom");
            this.bigScreenViewConfigDao.saveAll(ListUtil.of((Object[])new BigScreenViewConfig[]{init}));
        }
        if (CollectionUtils.isEmpty((Collection)(screenInfos = this.restGetScreenInfos(appCode)))) {
            this.bigScreenViewConfigDao.delete(new ArrayList(), tenantId, appCode);
        } else {
            Date date = new Date();
            List list = this.bigScreenViewConfigDao.findList(tenantId, appCode);
            HashMap<String, BigScreenViewConfig> map = new HashMap<String, BigScreenViewConfig>();
            HashMap<String, ScreenInfo> screenInfoMap = new HashMap<String, ScreenInfo>();
            for (BigScreenViewConfig bigScreenViewConfig : list) {
                map.put(bigScreenViewConfig.getBigScreenCode(), bigScreenViewConfig);
            }
            ArrayList<BigScreenViewConfig> newList = new ArrayList<BigScreenViewConfig>();
            ArrayList<String> deleteList = new ArrayList<String>();
            for (ScreenInfo screenInfo : screenInfos) {
                String code = screenInfo.getCode();
                screenInfoMap.put(code, screenInfo);
                BigScreenViewConfig bigScreenViewConfig = (BigScreenViewConfig)map.get(code);
                if (bigScreenViewConfig != null) continue;
                BigScreenViewConfig newConfig = this.buildBigScreenViewConfig(screenInfo, tenantId, appCode, date);
                newList.add(newConfig);
            }
            for (BigScreenViewConfig bigScreenViewConfig : list) {
                String bigScreenCode = bigScreenViewConfig.getBigScreenCode();
                ScreenInfo screenInfo = (ScreenInfo)screenInfoMap.get(bigScreenCode);
                if (screenInfo == null) {
                    deleteList.add(bigScreenCode);
                    continue;
                }
                String bigScreenName = bigScreenViewConfig.getBigScreenName();
                String bigScreenDescription = bigScreenViewConfig.getBigScreenDescription();
                String sceneTitle = screenInfo.getSceneTitle();
                String description = screenInfo.getDescription();
                if (this.compareStr(bigScreenName, sceneTitle).booleanValue() && this.compareStr(bigScreenDescription, description).booleanValue()) continue;
                bigScreenViewConfig.setBigScreenName(sceneTitle);
                bigScreenViewConfig.setBigScreenDescription(description);
                bigScreenViewConfig.setType("system");
                this.bigScreenViewConfigDao.update(bigScreenViewConfig);
            }
            if (!CollectionUtils.isEmpty(deleteList)) {
                this.bigScreenViewConfigDao.delete(deleteList, tenantId, appCode);
            }
            if (!CollectionUtils.isEmpty(newList)) {
                this.bigScreenViewConfigDao.saveAll(newList);
            }
        }
    }

    private BigScreenViewConfig buildBigScreenViewConfig(ScreenInfo screenInfo, String tenantId, String appCode, Date date) {
        BigScreenViewConfig bigScreenViewConfig = new BigScreenViewConfig();
        String string = UUID.randomUUID().toString();
        bigScreenViewConfig.setId(string);
        bigScreenViewConfig.setBigScreenCode(screenInfo.getCode());
        bigScreenViewConfig.setAppCode(appCode);
        bigScreenViewConfig.setTenantId(tenantId);
        bigScreenViewConfig.setBigScreenName(screenInfo.getSceneTitle());
        bigScreenViewConfig.setBigScreenDescription(screenInfo.getDescription());
        bigScreenViewConfig.setFlashFrequency(Integer.valueOf(5));
        bigScreenViewConfig.setPageTurningFrequency(Integer.valueOf(30));
        bigScreenViewConfig.setDataFlowFrequency(Integer.valueOf(10));
        bigScreenViewConfig.setType("system");
        return bigScreenViewConfig;
    }

    public List<BigScreenViewConfig> getBigScreenViewConfigs(String tenantId, String appCode) {
        return this.bigScreenViewConfigDao.findList(tenantId, appCode);
    }

    public BigScreenViewConfig getBigScreenViewConfig(String bigScreenViewConfigCode) {
        return this.bigScreenViewConfigDao.findOne(bigScreenViewConfigCode);
    }

    public void updateBigScreenViewConfig(BigScreenViewConfig bigScreenViewConfig) {
        Integer flashFrequency = bigScreenViewConfig.getFlashFrequency();
        if (flashFrequency == null || flashFrequency < 5 || flashFrequency > 120) {
            throw new DWBusinessException("\u5927\u5c4f\u6570\u636e\u5237\u65b0\u95f4\u9694\uff0c\u9ed8\u8ba45\u5206\u949f\uff0c\u6700\u5c0f5\u5206\u949f\uff0c\u6700\u5927120\u5206\u949f");
        }
        Integer pageTurningFrequency = bigScreenViewConfig.getPageTurningFrequency();
        if (pageTurningFrequency == null || pageTurningFrequency < 10 || pageTurningFrequency > 120) {
            throw new DWBusinessException("\u7248\u5757\u6570\u636e\u7ffb\u9875\u95f4\u9694\uff0c\u9ed8\u8ba430\u79d2\uff0c\u6700\u5c0f10\u79d2\uff0c\u6700\u5927120\u79d2");
        }
        AthenaUser user = AthenaUserLocal.getUser();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        bigScreenViewConfig.setUpdateTime(sdf.format(new Date()));
        bigScreenViewConfig.setUpdateUser(user.getUserName());
        this.bigScreenViewConfigDao.update(bigScreenViewConfig);
    }

    public BigScreenViewConfig getCustom(String tenantId, String appCode) {
        return this.bigScreenViewConfigDao.getCustom(tenantId, appCode);
    }

    public List<ScreenInfo> restGetScreenInfos(String appCode) throws Exception {
        return this.bigScreenViewConfigDao.postQuerySceneByApp(appCode);
    }

    private Boolean compareStr(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

