/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.digiwin.athena.agiledataquery.enums.NewSourceType;
import com.digiwin.athena.agiledataquery.service.inner.KgInnerService;
import com.digiwin.athena.agiledataquery.synonym.dao.BusinessTypeDao;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.BusinessType;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.synonym.service.BusinessTypeService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BusinessTypeServiceImpl
implements BusinessTypeService {
    private static final Logger log = LoggerFactory.getLogger(BusinessTypeServiceImpl.class);
    @Resource
    private BusinessTypeDao businessTypeDao;
    @Autowired
    private KgInnerService kgInnerService;

    public PageVo<BusinessType> getPage(String appCode, String tid, int pageSize, int pageNum) {
        return this.businessTypeDao.getPage(appCode, tid, pageSize, pageNum);
    }

    public BusinessType getSystemOne(String appCode, String code) {
        return this.businessTypeDao.getSystemOne(appCode, code);
    }

    public void update(BusinessType businessType) {
        businessType.setEditTime(null);
        AthenaUser user = AthenaUserLocal.getUser();
        if (null != user) {
            businessType.setEditBy(user.getUserName());
        }
        this.businessTypeDao.update(businessType);
    }

    public void syncData(String tid, String appCode) {
        if (StringUtils.isEmpty((CharSequence)tid)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.syncValueData(tid, appCode);
    }

    private void syncValueData(String tid, String appCode) {
        String tenantVersion = this.kgInnerService.getTenantVersion(tid);
        List systemBusinessTypes = this.businessTypeDao.querySystemBusinessTypeByVersion(appCode, tenantVersion);
        List businessTypes = this.businessTypeDao.findList(appCode, tid);
        if (CollectionUtils.isEmpty((Collection)systemBusinessTypes)) {
            DeleteVo deleteVo = new DeleteVo();
            deleteVo.setAppCode(appCode);
            deleteVo.setTid(tid);
            this.businessTypeDao.batchDelete(deleteVo);
            log.info("\u65e0\u9ed8\u8ba4\u4e1a\u52a1\u7c7b\u578b\uff0c\u5220\u9664\u4e1a\u52a1\u7c7b\u578b\uff0c\u540c\u6b65\u7ed3\u675f tid={}, appCode={}", (Object)tid, (Object)appCode);
            return;
        }
        ArrayList<BusinessType> insertList = new ArrayList<BusinessType>();
        Map businessTypeMap = businessTypes.stream().collect(Collectors.toMap(BusinessType::getCode, Function.identity(), (a, b) -> a));
        for (BusinessType businessType : systemBusinessTypes) {
            BusinessType localBusinessType = (BusinessType)businessTypeMap.get(businessType.getCode());
            if (null == localBusinessType || NewSourceType.SYSTEM.getCode().equals(localBusinessType.getSource())) {
                BusinessType insertBusinessType = new BusinessType();
                insertBusinessType.setSource(NewSourceType.SYSTEM.getCode());
                insertBusinessType.setTenantId(tid);
                insertBusinessType.setEditTime(new Date(businessType.getEditDate()));
                insertBusinessType.setCode(businessType.getCode());
                insertBusinessType.setName(businessType.getName());
                insertBusinessType.setAppCode(businessType.getAppCode());
                insertBusinessType.setShowType(businessType.getShowType());
                insertBusinessType.setLang(businessType.getLang());
                insertBusinessType.setDescription(businessType.getDescription());
                insertBusinessType.setEditBy(businessType.getEditBy());
                insertBusinessType.setDecimal(businessType.getDecimal());
                insertBusinessType.setDecimalRule(businessType.getDecimalRule());
                insertBusinessType.setDataUnit(businessType.getDataUnit());
                if (null != localBusinessType && NewSourceType.SYSTEM.getCode().equals(localBusinessType.getSource())) {
                    insertBusinessType.setEditBy(localBusinessType.getEditBy());
                    insertBusinessType.setEditTime(localBusinessType.getEditTime());
                }
                insertList.add(insertBusinessType);
                continue;
            }
            insertList.add(localBusinessType);
        }
        DeleteVo deleteVo = new DeleteVo();
        deleteVo.setAppCode(appCode);
        deleteVo.setTid(tid);
        this.businessTypeDao.batchDelete(deleteVo);
        this.businessTypeDao.batchInsert(insertList);
    }
}

