/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.synonym.dao.SmartUserConfigRest;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.CheckSmartUserRequest;
import com.digiwin.athena.agiledataquery.synonym.domain.QuerySmartUserRequest;
import com.digiwin.athena.agiledataquery.synonym.domain.SmartUserConfig;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteVo;
import com.digiwin.athena.agiledataquery.synonym.service.SmartUserConfigService;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SmartUserConfigServiceImpl
implements SmartUserConfigService {
    private static final Logger log = LoggerFactory.getLogger(SmartUserConfigServiceImpl.class);
    @Resource
    private SmartUserConfigRest smartUserConfigDao;
    @Value(value="${iamUrl}")
    private String iamUrl;
    @Value(value="${iamApToken}")
    private String appToken;
    private static final String queryAllTenantUser = "/api/iam/v2/tenant/user/list";

    public Boolean checkUser(CheckSmartUserRequest request) {
        List configs = this.smartUserConfigDao.findList(request.getTenantId(), request.getUserId(), null, null);
        return CollectionUtils.isNotEmpty((Collection)configs);
    }

    public List<SmartUserConfig> findList(QuerySmartUserRequest request) {
        return this.smartUserConfigDao.findList(request.getTenantId(), null, request.getKeyWord(), null);
    }

    public void saveAll(List<SmartUserConfig> configs) {
        List smartUserConfigs = this.smartUserConfigDao.findList(configs.get(0).getTenantId(), null, null, null);
        configs = configs.stream().filter(config -> CollectionUtils.isEmpty((Collection)smartUserConfigs.stream().filter(x -> x.getUserId().equals(config.getUserId()) && x.getTenantId().equals(config.getTenantId())).collect(Collectors.toList()))).collect(Collectors.toList());
        configs.stream().forEach(config -> config.setId(UUID.randomUUID().toString()));
        this.smartUserConfigDao.saveAll(configs);
    }

    public void delete(DeleteVo deleteVo) {
        this.smartUserConfigDao.delete(deleteVo.getIds());
    }

    public List<JSONObject> queryUserInTenant(String tenantId, String keyWord) {
        String queryUserInTenantsUrl = "/api/iam/v2/tenant/user/list?pageSize=1000&pageNum=1";
        JSONObject paramJson = new JSONObject();
        paramJson.put("tenantId", (Object)tenantId);
        String response = ((HttpRequest)((HttpRequest)HttpUtil.createPost((String)(this.iamUrl + queryUserInTenantsUrl)).header("digi-middleware-auth-app", this.appToken)).header("digi-middleware-auth-user", AthenaUserLocal.getUser().getToken())).body(paramJson.toJSONString()).execute().body();
        try {
            List configs;
            JSONObject responseObj = JSON.parseObject((String)response);
            List<Object> users = responseObj.getJSONArray("list").toJavaList(JSONObject.class);
            users = users.stream().filter(user -> !tenantId.equals(user.getString("id"))).collect(Collectors.toList());
            if (StringUtils.isNotEmpty((CharSequence)keyWord)) {
                users = users.stream().filter(user -> {
                    String name = user.getString("name");
                    String id = user.getString("id");
                    return name.contains(keyWord) || id.contains(keyWord);
                }).collect(Collectors.toList());
            }
            if (CollectionUtils.isNotEmpty((Collection)(configs = this.smartUserConfigDao.findList(tenantId, null, null, null)))) {
                List smartUser = configs.stream().map(SmartUserConfig::getUserId).collect(Collectors.toList());
                users = users.stream().filter(user -> !smartUser.contains((String)user.get((Object)"id"))).collect(Collectors.toList());
            }
            return users;
        }
        catch (Exception e) {
            JSONObject responseObj = JSON.parseObject((String)response);
            log.error("\u67e5\u8be2\u7528\u6237\u5931\u8d25:{}", (Object)response);
            throw new DWBusinessException(responseObj.getString("errorMessage"));
        }
    }
}

