/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.domain.definition.actions.MultiLanguageDTO;
import com.digiwin.athena.agiledataquery.synonym.dao.ErrorSynonymRest;
import com.digiwin.athena.agiledataquery.synonym.dao.SynonymRest;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.EntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.ErrorSynonym;
import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.domain.po.CallableReturn;
import com.digiwin.athena.agiledataquery.synonym.domain.po.ExportVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.PageVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.SynonymExcelVo;
import com.digiwin.athena.agiledataquery.synonym.excelConfig.SynonymListener;
import com.digiwin.athena.agiledataquery.synonym.service.EntityTypeService;
import com.digiwin.athena.agiledataquery.synonym.service.SynonymService;
import com.digiwin.athena.agiledataquery.synonym.service.TranslateService;
import com.digiwin.athena.agiledataquery.synonym.service.impl.SynonymUtil;
import com.digiwin.athena.agiledataquery.synonym.thread.SaveAndInsertThread;
import com.digiwin.athena.agiledataquery.synonym.util.RestUtil;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SynonymServiceImpl
implements SynonymService {
    private static final Logger log = LoggerFactory.getLogger(SynonymServiceImpl.class);
    @Autowired
    private SynonymRest synonymDao;
    @Autowired
    private ErrorSynonymRest errorSynonymDao;
    @Autowired
    private EntityTypeService entityTypeService;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${rest-url.pushSynonymUrl}")
    private String pushSynonymUrl;
    public static final String UPSERT = "es/metadata/upsert";
    public static final String DELETE = "es/metadata/delete";
    @Autowired
    private TranslateService translationService;
    @Autowired
    @Qualifier(value="taskExecutor")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private SynonymUtil synonymUtil;
    private static String PUSH_IN = "/scrumbi/pushStandardWord";
    @Value(value="${iamApToken}")
    private String appToken;

    public void creatOrUpdate(Synonym synonymVo) {
        if (synonymVo == null || StringUtils.isEmpty((CharSequence)synonymVo.getTenantId()) || StringUtils.isEmpty((CharSequence)synonymVo.getProperNoun()) || StringUtils.isEmpty((CharSequence)synonymVo.getEntityTypeName())) {
            throw new DWBusinessException("\u5fc5\u8981\u53c2\u6570\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5b8c\u6574\u6027");
        }
        SynonymUtil.parseCreateList((Synonym)synonymVo);
        boolean msg = SynonymUtil.checkOnSynonym((Synonym)synonymVo);
        if (!msg) {
            throw new DWBusinessException("\u5728\u4e13\u6709\u540d\u8bcd,\u7b80\u7e41\u4f53\u540c\u4e49\u8bcd\u4e2d\u5b58\u5728\u91cd\u590d,\u8bf7\u68c0\u67e5");
        }
        Synonym synonym = this.synonymDao.findOne(synonymVo.getTenantId(), synonymVo.getEntityTypeName(), synonymVo.getProperNoun());
        if (synonym == null) {
            this.create(synonymVo);
        } else {
            this.updateOnCreate(synonym, synonymVo);
        }
    }

    private void updateOnCreate(Synonym oldSynonym, Synonym newSynonym) {
        Synonym synonym = SynonymUtil.syncSynonym((Synonym)oldSynonym, (Synonym)newSynonym);
        this.synonymDao.insertOrUpdate(synonym);
        ArrayList<Synonym> arrayList = new ArrayList<Synonym>();
        arrayList.add(synonym);
        this.pushData(arrayList);
    }

    private void create(Synonym synonym) {
        synonym.setObjectId(SynonymUtil.getId((Synonym)synonym));
        try {
            this.synonymDao.insertOrUpdate(synonym);
        }
        catch (Exception e) {
            return;
        }
        ArrayList<Synonym> arrayList = new ArrayList<Synonym>();
        arrayList.add(synonym);
        this.pushData(arrayList);
    }

    public PageVo getList(String properNoun, String entityTypeName, String tenantId, String des, int page, int pageSize) throws IOException {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map entityLang = this.getEntityLang(tenantId);
        PageVo listPage = this.synonymDao.findListPage(tenantId, properNoun, entityTypeName, des, page, pageSize);
        List list = listPage.getList();
        for (Synonym synonym : list) {
            Map stringMultiLanguageDTOMap = (Map)entityLang.get(synonym.getEntityTypeName());
            if (stringMultiLanguageDTOMap == null) continue;
            synonym.setLang(stringMultiLanguageDTOMap);
        }
        return listPage;
    }

    public void delete(List<String> id, String tenantId) {
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            throw new DWBusinessException("\u79df\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List list = this.synonymDao.findList(tenantId, id);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Synonym synonym : list) {
                synonym.setDelFlag(Integer.valueOf(1));
            }
        }
        this.synonymDao.delete(id, tenantId);
        this.pushData(list);
    }

    public void downloadTemplate(HttpServletResponse response) {
        SynonymUtil.downloadExcel(new ArrayList(), (HttpServletResponse)response);
    }

    public void downloadData(HttpServletResponse response, ExportVo exportVo) throws IOException {
        List list = this.synonymDao.findList(exportVo.getTenantId(), exportVo.getProperNoun(), exportVo.getEntityTypeName(), exportVo.getDes());
        Map entityLang = this.getEntityLang(exportVo.getTenantId());
        String locale = AthenaUserLocal.getLocale();
        ArrayList<SynonymExcelVo> synonymExcelVos = new ArrayList<SynonymExcelVo>();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (Synonym synonym : list) {
                Map stringMultiLanguageDTOMap = (Map)entityLang.get(synonym.getEntityTypeName());
                SynonymExcelVo synonymExcelVo = new SynonymExcelVo();
                if (stringMultiLanguageDTOMap != null) {
                    MultiLanguageDTO entityName = (MultiLanguageDTO)stringMultiLanguageDTOMap.get("entityTypeName");
                    String zhTw = entityName.getZh_TW();
                    if ("zh_TW".equalsIgnoreCase(locale)) {
                        synonymExcelVo.setEntityTypeName(zhTw);
                    }
                    if ("zh_CN".equalsIgnoreCase(locale)) {
                        synonymExcelVo.setEntityTypeName(synonym.getEntityTypeName());
                    }
                }
                synonymExcelVo.setProperNoun(synonym.getProperNoun());
                synonymExcelVo.setZh_CN_Str(synonym.getZh_CN_Str());
                synonymExcelVo.setDescription(synonym.getDescription());
                synonymExcelVos.add(synonymExcelVo);
            }
        }
        SynonymUtil.downloadExcel(synonymExcelVos, (HttpServletResponse)response);
    }

    public JSONObject uploadData(MultipartFile file, HttpServletResponse response, String tenantId, HttpServletRequest request) {
        JSONObject jsonObject = new JSONObject();
        long size = file.getSize();
        if (size == 0L) {
            jsonObject.put("code", (Object)1);
            jsonObject.put("msg", (Object)"\u6587\u4ef6\u5927\u5c0f\u4e3a\u7a7a");
            return jsonObject;
        }
        try {
            List entityTypes = this.entityTypeService.findList(tenantId);
            SynonymListener synonymListener = new SynonymListener();
            EasyExcel.read((InputStream)file.getInputStream(), SynonymExcelVo.class, (ReadListener)synonymListener).sheet().doRead();
            List list = synonymListener.getList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                List synonymList;
                Map entityLang = this.getZhCn(tenantId);
                for (SynonymExcelVo synonymExcelVo : list) {
                    String stringMultiLanguageDTOMap = (String)entityLang.get(synonymExcelVo.getEntityTypeName());
                    if (StringUtils.isEmpty((CharSequence)stringMultiLanguageDTOMap)) continue;
                    synonymExcelVo.setEntityTypeName(stringMultiLanguageDTOMap);
                }
                List synonyms = SynonymUtil.parseSynonymExcel((List)list, (String)tenantId);
                JSONObject jsonObject1 = this.mapSynonym(synonyms, tenantId, entityTypes, synonymList = this.synonymDao.findList(tenantId, new ArrayList()));
                if (jsonObject1 != null) {
                    return jsonObject1;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    public void downErrorData(HttpServletResponse response, String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            throw new DWBusinessException("\u9519\u8bef\u6587\u4ef6\u6807\u8bc6\u4e3a\u7a7a");
        }
        ErrorSynonym one = this.errorSynonymDao.getOne(id);
        SynonymUtil.downloadExcel((List)one.getSynonymExcelVos(), (HttpServletResponse)response);
    }

    public JSONObject mapSynonym(List<Synonym> sourceList, String tenantId, List<EntityType> entityTypes, List<Synonym> synonymList) {
        ErrorSynonym errorSynonym1 = SynonymUtil.checkSynonymsOnList(sourceList, entityTypes);
        if (errorSynonym1 != null) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)1);
            jsonObject.put("msg", (Object)"\u4e0a\u4f20\u540c\u4e49\u8bcd\u6587\u4ef6\u5185\u5bb9\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5");
            jsonObject.put("fileName", (Object)errorSynonym1.getId());
            this.errorSynonymDao.insert(errorSynonym1);
            return jsonObject;
        }
        if (CollectionUtils.isEmpty(synonymList)) {
            for (Synonym synonym : sourceList) {
                synonym.setObjectId(SynonymUtil.getId((Synonym)synonym));
            }
            this.synonymDao.saveAll(sourceList);
            Boolean b = this.pushData(sourceList);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("code", (Object)0);
            jsonObject.put("pushResult", (Object)b);
            jsonObject.put("size", (Object)sourceList.size());
            return jsonObject;
        }
        Map oldMap = this.synonymUtil.getMap(synonymList);
        CallableReturn callableReturn = this.synonymUtil.groupSynonym(sourceList, oldMap, tenantId, entityTypes);
        ErrorSynonym errorSynonym = callableReturn.getErrorSynonym();
        if (errorSynonym == null) {
            Map map = callableReturn.getMap();
            if (map == null) {
                return null;
            }
            List updateList = (List)map.get("2");
            List insertList = (List)map.get("1");
            AthenaUser user = AthenaUserLocal.getUser();
            SaveAndInsertThread saveAndInsertThread = new SaveAndInsertThread(this.synonymDao, this.restTemplate, updateList, insertList, this.pushSynonymUrl, user, this.appToken);
            Future submit = this.threadPoolTaskExecutor.submit((Callable)saveAndInsertThread);
            try {
                return (JSONObject)submit.get();
            }
            catch (Exception e) {
                log.error("get result error:", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)1);
        jsonObject.put("msg", (Object)"\u4e0a\u4f20\u540c\u4e49\u8bcd\u6587\u4ef6\u5185\u5bb9\u672a\u901a\u8fc7\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5");
        jsonObject.put("fileName", (Object)errorSynonym.getId());
        this.errorSynonymDao.insert(errorSynonym);
        return jsonObject;
    }

    public Boolean pushData(List<Synonym> sourceList) {
        return this.oldPushData(sourceList);
    }

    @Async
    public void pushOnceAllSynonym(HttpServletRequest request, String tenantId) {
        log.info("\u654f\u6377\u6570\u636e-\u521d\u59cb\u5316\u63a8\u9001\u540c\u4e49\u8bcd\u7ed9\u8bed\u4e49\u7ec4-\u4efb\u52a1\u5f00\u59cb");
        String token = request.getHeader("token");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", token);
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        int i = 0;
        while (true) {
            try {
                List all;
                while (!CollectionUtils.isEmpty((Collection)(all = this.synonymDao.findAll(i, 10000)))) {
                    List synonymHttpVos = SynonymUtil.parseSynonymHttpVo((List)all);
                    log.info("\u654f\u6377\u6570\u636e-\u521d\u59cb\u5316\u63a8\u9001\u540c\u4e49\u8bcd\u7ed9\u8bed\u4e49\u7ec4-\u5f00\u59cb\u63a8\u9001\u7b2c" + (i + 1) + "\u7ec4\u6570\u636e\uff0c\u5f53\u524d\u63a8\u9001" + synonymHttpVos.size() + "\u6761");
                    JSONObject jsonObject = new JSONObject();
                    JSONArray objects = JSONArray.parseArray((String)JSONObject.toJSONString((Object)synonymHttpVos));
                    jsonObject.put("standardWordDatas", (Object)objects);
                    HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
                    log.info("tdd\u5f00\u59cb\u5411\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + "/scrumbi/sync/pushStandardWord\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size());
                    ResponseEntity result = this.restTemplate.postForEntity(this.pushSynonymUrl + "/scrumbi/sync/pushStandardWord", (Object)httpEntity, JSONObject.class, new Object[0]);
                    log.info("\u654f\u6377\u6570\u636e-\u521d\u59cb\u5316\u63a8\u9001\u540c\u4e49\u8bcd\u7ed9\u8bed\u4e49\u7ec4-\u56de\u53c2" + ((JSONObject)result.getBody()).toJSONString());
                    ++i;
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
                log.info("\u654f\u6377\u6570\u636e-\u521d\u59cb\u5316\u63a8\u9001\u540c\u4e49\u8bcd\u7ed9\u8bed\u4e49\u7ec4-\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u7ec4:" + i);
                continue;
            }
            break;
        }
        log.info("\u654f\u6377\u6570\u636e-\u521d\u59cb\u5316\u63a8\u9001\u540c\u4e49\u8bcd\u7ed9\u8bed\u4e49\u7ec4-\u4efb\u52a1\u5b8c\u6210");
    }

    public Boolean oldPushData(List<Synonym> sourceList) {
        try {
            List synonymHttpVos = SynonymUtil.parseSynonymHttpVo(sourceList);
            HttpHeaders headers = RestUtil.getHeaders();
            JSONObject jsonObject = new JSONObject();
            JSONArray objects = JSONArray.parseArray((String)JSONObject.toJSONString((Object)synonymHttpVos));
            jsonObject.put("standardWordDatas", (Object)objects);
            HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
            log.info("tdd\u5f00\u59cb\u5411\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size());
            ResponseEntity result = this.restTemplate.postForEntity(this.pushSynonymUrl + PUSH_IN, (Object)httpEntity, JSONObject.class, new Object[0]);
            int statusCodeValue = result.getStatusCodeValue();
            if (statusCodeValue != 200) {
                log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size() + "\u5931\u8d25\u5185\u5bb9" + result.toString());
                ErrorSynonym errorSynonym = new ErrorSynonym();
                errorSynonym.setId(UUID.randomUUID().toString());
                errorSynonym.setSynonyms(sourceList);
                errorSynonym.setErrorFlag(Integer.valueOf(1));
                errorSynonym.setMsg("\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + ((JSONObject)result.getBody()).toJSONString());
                this.errorSynonymDao.insert(errorSynonym);
                return false;
            }
            JSONObject body = (JSONObject)result.getBody();
            if (body == null || StringUtils.isEmpty((CharSequence)body.getString("code")) || !body.getString("code").equals("200")) {
                log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size() + "\u5931\u8d25\u5185\u5bb9" + result.toString());
                ErrorSynonym errorSynonym = new ErrorSynonym();
                errorSynonym.setId(UUID.randomUUID().toString());
                errorSynonym.setSynonyms(sourceList);
                errorSynonym.setErrorFlag(Integer.valueOf(1));
                errorSynonym.setMsg("\u63a5\u53e3\u8c03\u7528\u5931\u8d25" + ((JSONObject)result.getBody()).toJSONString());
                this.errorSynonymDao.insert(errorSynonym);
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u5f02\u5e38\u4fe1\u606f" + exception.getMessage());
            ErrorSynonym errorSynonym = new ErrorSynonym();
            errorSynonym.setId(UUID.randomUUID().toString());
            errorSynonym.setSynonyms(sourceList);
            errorSynonym.setErrorFlag(Integer.valueOf(1));
            errorSynonym.setMsg(exception.getMessage());
            this.errorSynonymDao.insert(errorSynonym);
            return false;
        }
        return true;
    }

    public void update(Synonym synonym) {
        if (synonym == null || StringUtils.isEmpty((CharSequence)synonym.getObjectId()) || StringUtils.isEmpty((CharSequence)synonym.getTenantId())) {
            throw new DWBusinessException("\u5b58\u5728\u5fc5\u586b\u53c2\u6570\u4e3a\u4f20\uff0c\u8bf7\u68c0\u67e5objectid\u4e0etenantId");
        }
        SynonymUtil.parseUpdateList((Synonym)synonym);
        List zhCn = synonym.getZh_CN();
        if (!SynonymUtil.checkList((List)zhCn).booleanValue()) {
            throw new DWBusinessException("\u7b80\u4f53\u6216\u8005\u7e41\u4f53\u540c\u4e49\u8bcd\u5185\u5b58\u5728\u91cd\u590d\u5185\u5bb9");
        }
        boolean msg = SynonymUtil.checkOnSynonym((Synonym)synonym);
        if (!msg) {
            throw new DWBusinessException("\u5728\u4e13\u6709\u540d\u8bcd,\u7b80\u7e41\u4f53\u540c\u4e49\u8bcd\u4e2d\u5b58\u5728\u91cd\u590d,\u8bf7\u68c0\u67e5(\u7b80\u4f53\u8bcd\u4e0e\u7e41\u4f53\u8bcd\u53ef\u4ee5\u6709\u76f8\u540c\u8bcd,\u4f46\u662f\u540c\u7b80\u4f53\u6216\u8005\u7e41\u4f53\u8bcd\u4e0d\u540c\u6709\u91cd\u590d\u6570\u636e)");
        }
        this.synonymDao.insertOrUpdate(synonym);
        ArrayList<Synonym> synonyms = new ArrayList<Synonym>();
        synonyms.add(synonym);
        this.pushData(synonyms);
    }

    public JSONObject batchSave(List<Synonym> sourceList, String tenantId, List<Synonym> synonymList) throws IOException {
        List list = this.entityTypeService.findList(tenantId);
        return this.mapSynonym(sourceList, tenantId, list, synonymList);
    }

    public void twToCn(String tenantId) {
        List list = this.synonymDao.findList(tenantId, new ArrayList());
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        int i = 1;
        for (List synonyms : SynonymServiceImpl.partition((List)list, (int)5000)) {
            System.out.println("\u79df\u6237" + tenantId + "\u5171\u8ba1" + list.size() + "\u6570\u636e,\u73b0\u5728\u5f00\u59cb\u63a8\u9001\u6570\u636e\u6279\u6b21" + i);
            this.pushData(synonyms);
            ++i;
        }
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        ArrayList<List<T>> partitionedList = new ArrayList<List<T>>();
        int totalSize = list.size();
        for (int i = 0; i < totalSize; i += size) {
            partitionedList.add(list.subList(i, Math.min(i + size, totalSize)));
        }
        return partitionedList;
    }

    public Map<String, Map<String, MultiLanguageDTO>> getEntityLang(String tenantId) throws IOException {
        List entityTypes = this.entityTypeService.findList(tenantId);
        if (!CollectionUtils.isEmpty((Collection)entityTypes)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (EntityType entityType : entityTypes) {
                map.put(entityType.getEntityTypeName(), entityType.getEntityTypeName());
            }
            return this.translationService.translateBatch(map, "entityTypeName");
        }
        return null;
    }

    public Map<String, String> getZhCn(String tenantId) throws IOException {
        List entityTypes = this.entityTypeService.findList(tenantId);
        if (!CollectionUtils.isEmpty((Collection)entityTypes)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (EntityType entityType : entityTypes) {
                map.put(entityType.getEntityTypeName(), entityType.getEntityTypeName());
            }
            HashMap<String, String> map1 = new HashMap<String, String>();
            Map entityName = this.translationService.translateBatch(map, "entityTypeName");
            Set entries = entityName.entrySet();
            for (Map.Entry entry : entries) {
                Map value = (Map)entry.getValue();
                String key = (String)entry.getKey();
                MultiLanguageDTO entityName1 = (MultiLanguageDTO)value.get("entityTypeName");
                String zhTw = entityName1.getZh_TW();
                map1.put(zhTw, key);
            }
            return map1;
        }
        return null;
    }
}

