/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.handler.WriteHandler;
import com.digiwin.athena.agiledataquery.synonym.domain.EntityType;
import com.digiwin.athena.agiledataquery.synonym.domain.ErrorSynonym;
import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.domain.po.CallableReturn;
import com.digiwin.athena.agiledataquery.synonym.domain.po.CheckSynonymResult;
import com.digiwin.athena.agiledataquery.synonym.domain.po.DeleteData;
import com.digiwin.athena.agiledataquery.synonym.domain.po.RHSynonymHttpVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.RhData;
import com.digiwin.athena.agiledataquery.synonym.domain.po.RhDataData;
import com.digiwin.athena.agiledataquery.synonym.domain.po.SynonymExcelVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.SynonymHttpVo;
import com.digiwin.athena.agiledataquery.synonym.domain.po.UpsertData;
import com.digiwin.athena.agiledataquery.synonym.excelConfig.CustomHeadColumnWidthStrategy;
import com.digiwin.athena.agiledataquery.synonym.excelConfig.CustomRowHightStrategy;
import com.digiwin.athena.agiledataquery.synonym.excelConfig.ExcelStyleTool;
import com.digiwin.athena.agiledataquery.synonym.thread.SynonymGroupCallable;
import com.digiwin.athena.agiledataquery.synonym.thread.SynonymMapCallable;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SynonymUtil {
    private static final Logger log = LoggerFactory.getLogger(SynonymUtil.class);
    @Autowired
    @Qualifier(value="taskExecutor")
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public static ErrorSynonym checkSynonymsOnList(List<Synonym> synonyms, List<EntityType> entityTypes) {
        List<Object> names = new ArrayList();
        if (!CollectionUtils.isEmpty(entityTypes)) {
            names = entityTypes.stream().map(EntityType::getEntityTypeName).collect(Collectors.toList());
        }
        ArrayList<SynonymExcelVo> errorVos = new ArrayList<SynonymExcelVo>();
        HashMap map = new HashMap();
        for (Synonym synonym : synonyms) {
            SynonymExcelVo synonymExcelVo = new SynonymExcelVo();
            String entityTypeName = synonym.getEntityTypeName();
            String properNoun = synonym.getProperNoun();
            Boolean flag = false;
            if (map.containsKey(entityTypeName + "_" + properNoun)) {
                synonymExcelVo.setProperNoun(properNoun + "\u4e13\u6709\u6709\u540d\u8bcd\u4e0e\u5b9e\u4f53\u7c7b\u578b\u91cd\u590d\uff01");
                synonymExcelVo.setEntityTypeName(entityTypeName);
                flag = true;
            } else {
                map.put(entityTypeName + "_" + properNoun, null);
            }
            if (StringUtils.isEmpty((CharSequence)entityTypeName)) {
                synonymExcelVo.setEntityTypeName("\u5b9e\u4f53\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                flag = true;
            } else if (!names.contains(entityTypeName)) {
                synonymExcelVo.setEntityTypeName(entityTypeName + "\u4e0d\u5728\u5b9e\u4f53\u7c7b\u578b\u8303\u56f4\u5185");
                flag = true;
            }
            if (StringUtils.isEmpty((CharSequence)properNoun)) {
                synonymExcelVo.setProperNoun("\u4e13\u6709\u6709\u540d\u8bcd\u4e0d\u80fd\u4e3a\u7a7a");
                flag = true;
            }
            if (flag.booleanValue()) {
                synonymExcelVo.setDescription(synonym.getDescription());
                synonymExcelVo.setZh_CN_Str(synonym.getZh_CN_Str());
                errorVos.add(synonymExcelVo);
                continue;
            }
            String zhCnStr = synonym.getZh_CN_Str();
            List split = SynonymUtil.split((String)zhCnStr);
            String s = SynonymUtil.list2Str((List)split);
            synonym.setZh_CN_Str(s);
            synonym.setZh_CN(split);
        }
        if (CollectionUtils.isEmpty(errorVos)) {
            return null;
        }
        ErrorSynonym errorSynonym = new ErrorSynonym();
        errorSynonym.setId(UUID.randomUUID().toString());
        errorSynonym.setSynonymExcelVos(errorVos);
        return errorSynonym;
    }

    public static ErrorSynonym checkSynonyms(List<Synonym> synonyms, Map<String, Synonym> map, List<EntityType> entityTypes) {
        return null;
    }

    public static Boolean checkList(List<String> list) {
        if (list == null) {
            return true;
        }
        HashSet<String> strings = new HashSet<String>(list);
        return strings.size() == list.size();
    }

    public static Boolean checkReList(List<String> target, List<String> source) {
        if (CollectionUtils.isEmpty(target) || CollectionUtils.isEmpty(source)) {
            return true;
        }
        for (String s : target) {
            if (!source.contains(s)) continue;
            return false;
        }
        return true;
    }

    public static Boolean checkOnSynonym(Synonym synonym) {
        String properNoun = synonym.getProperNoun();
        List zhCn = synonym.getZh_CN();
        if (!CollectionUtils.isEmpty((Collection)zhCn)) {
            if (zhCn.contains(properNoun)) {
                return false;
            }
            HashSet strings = new HashSet(zhCn);
            if (strings.size() != zhCn.size()) {
                return false;
            }
        }
        return true;
    }

    public static List<String> split(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return new ArrayList<String>();
        }
        String[] split = s.split("/");
        List<String> list = Arrays.asList(split);
        HashSet<String> newList = new HashSet<String>();
        for (String string : list) {
            if (!StringUtils.isNotEmpty((CharSequence)string)) continue;
            String trim = string.trim();
            newList.add(trim);
        }
        return new ArrayList<String>(newList);
    }

    public static void main(String[] args) {
        List split = SynonymUtil.split((String)"\u7eaf\u68c9//////\u662f\u4f60\u7684");
        System.out.println(split.size());
    }

    public static List<String> refresh(List<String> list, String str) {
        List split = SynonymUtil.split((String)str);
        if (CollectionUtils.isEmpty((Collection)split)) {
            return list;
        }
        if (CollectionUtils.isEmpty(list)) {
            list = split;
        } else {
            list.addAll(split);
        }
        HashSet hashSet = new HashSet(list);
        return new ArrayList<String>(hashSet);
    }

    public static String list2Str(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : list) {
            stringBuilder.append(s).append("/");
        }
        String string = stringBuilder.toString();
        return string.substring(0, string.lastIndexOf("/"));
    }

    public static Synonym syncSynonym(Synonym oldS, Synonym newS) {
        List zhCn = oldS.getZh_CN();
        String zhCnStr = newS.getZh_CN_Str();
        List cn = SynonymUtil.refresh((List)zhCn, (String)zhCnStr);
        oldS.setZh_CN(cn);
        oldS.setZh_CN_Str(SynonymUtil.list2Str((List)cn));
        String description = newS.getDescription();
        if (StringUtils.isNotEmpty((CharSequence)description)) {
            oldS.setDescription(description);
        }
        return oldS;
    }

    public static void parseCreateList(Synonym synonym) {
        String zhCnStr = synonym.getZh_CN_Str();
        List cn = SynonymUtil.split((String)zhCnStr);
        synonym.setZh_CN(cn);
    }

    public static void parseUpdateList(Synonym synonym) {
        String zhCnStr = synonym.getZh_CN_Str();
        List cn = SynonymUtil.split((String)zhCnStr);
        synonym.setZh_CN(cn);
    }

    public static void downloadExcel(List<SynonymExcelVo> excelVos, HttpServletResponse response) {
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''\u4e13\u6709\u540d\u79f0\u6a21\u677f.xlsx");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        try {
            ServletOutputStream outputStream = response.getOutputStream();
            EasyExcel.write((OutputStream)outputStream, SynonymExcelVo.class).inMemory(Boolean.TRUE).sheet("\u6a21\u677f").registerWriteHandler((WriteHandler)ExcelStyleTool.getStyleStrategy()).registerWriteHandler((WriteHandler)new CustomHeadColumnWidthStrategy()).registerWriteHandler((WriteHandler)new CustomRowHightStrategy()).doWrite(excelVos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<EntityType> getDefultEntityList(String tid) {
        ArrayList<EntityType> list = new ArrayList<EntityType>();
        EntityType entityType = new EntityType();
        entityType.setEntityTypeName("\u7ef4\u5ea6");
        entityType.setDeleteFlag(Boolean.valueOf(true));
        entityType.setObjectId(UUID.randomUUID().toString());
        entityType.setTenantId(tid);
        EntityType entityType1 = new EntityType();
        entityType1.setEntityTypeName("\u76ee\u6807");
        entityType1.setDeleteFlag(Boolean.valueOf(true));
        entityType1.setObjectId(UUID.randomUUID().toString());
        entityType1.setTenantId(tid);
        list.add(entityType);
        list.add(entityType1);
        return list;
    }

    public static List<Synonym> parseSynonymExcel(List<SynonymExcelVo> excelVos, String tid) {
        ArrayList<Synonym> list = new ArrayList<Synonym>();
        if (CollectionUtils.isEmpty(excelVos)) {
            return list;
        }
        for (SynonymExcelVo synonymExcelVo : excelVos) {
            Synonym synonym = SynonymUtil.parseSynonymExcelOne((SynonymExcelVo)synonymExcelVo, (String)tid);
            list.add(synonym);
        }
        return list;
    }

    public static Synonym parseSynonymExcelOne(SynonymExcelVo excelVos, String tid) {
        Synonym synonym = new Synonym();
        synonym.setTenantId(tid);
        synonym.setDescription(excelVos.getDescription());
        synonym.setProperNoun(excelVos.getProperNoun());
        synonym.setEntityTypeName(excelVos.getEntityTypeName());
        synonym.setZh_CN_Str(excelVos.getZh_CN_Str());
        synonym.setZh_CN(SynonymUtil.split((String)excelVos.getZh_CN_Str()));
        return synonym;
    }

    public static List<SynonymHttpVo> parseSynonymHttpVo(List<Synonym> list) {
        ArrayList<SynonymHttpVo> synonymHttpVos = new ArrayList<SynonymHttpVo>();
        if (CollectionUtils.isEmpty(list)) {
            return synonymHttpVos;
        }
        for (Synonym synonym : list) {
            SynonymHttpVo synonymHttpVo = new SynonymHttpVo();
            synonymHttpVo.setId(synonym.getObjectId());
            synonymHttpVo.setFlag(synonym.getDelFlag());
            synonymHttpVo.setSimChinese(synonym.getZh_CN());
            synonymHttpVo.setDescription(synonym.getDescription());
            synonymHttpVo.setTenantId(synonym.getTenantId());
            synonymHttpVo.setProperNoun(synonym.getProperNoun());
            synonymHttpVo.setEntityTypeName(synonym.getEntityTypeName());
            synonymHttpVos.add(synonymHttpVo);
        }
        return synonymHttpVos;
    }

    public static CheckSynonymResult checkSynonym(Synonym synonym, List<Synonym> list, Boolean updateFlag) {
        ArrayList oldZhCn;
        String properNoun = synonym.getProperNoun();
        List zhCn = synonym.getZh_CN();
        Synonym old = null;
        if (!CollectionUtils.isEmpty((Collection)zhCn) && zhCn.contains(properNoun)) {
            return new CheckSynonymResult(Boolean.valueOf(false), "\u4e13\u6709\u540d\u8bcd\u4e0e\u540c\u4e49\u8bcd\u53d1\u73b0\u91cd\u590d\u5185\u5bb9\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58");
        }
        if (CollectionUtils.isEmpty(list)) {
            return new CheckSynonymResult(Boolean.valueOf(true), "");
        }
        ArrayList per = new ArrayList();
        ArrayList<String> des = new ArrayList<String>();
        for (Synonym s : list) {
            if (s.getObjectId().equals(synonym.getObjectId())) {
                old = s;
                continue;
            }
            List zhCn1 = s.getZh_CN();
            if (!CollectionUtils.isEmpty((Collection)zhCn1)) {
                per.addAll(zhCn1);
            }
            des.add(s.getDescription());
        }
        if (old == null && updateFlag.booleanValue()) {
            throw new DWBusinessException("\u5f53\u524d\u4fee\u6539\u7684\u6570\u636e\u5b58\u5728\u5f02\u5e38!\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
        }
        if (old == null) {
            old = new Synonym();
        }
        if (CollectionUtils.isEmpty((Collection)(oldZhCn = old.getZh_CN()))) {
            oldZhCn = new ArrayList();
        }
        if (per.contains(properNoun)) {
            return new CheckSynonymResult(Boolean.valueOf(false), "\u4e13\u6709\u540d\u8bcd\u5df2\u5b58\u5728\u5176\u4ed6\u8bcd\u6761\u4e2d");
        }
        if (!CollectionUtils.isEmpty((Collection)zhCn)) {
            StringBuilder msg = new StringBuilder();
            Boolean flag = true;
            for (String s : zhCn) {
                if (!per.contains(s) || oldZhCn.contains(s)) continue;
                flag = false;
                msg.append(s).append(" ");
            }
            if (!flag.booleanValue()) {
                return new CheckSynonymResult(flag, msg.append(" \u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58").toString());
            }
        }
        Boolean desFlag = false;
        if (!StringUtils.isEmpty((CharSequence)old.getDescription()) && !StringUtils.isEmpty((CharSequence)synonym.getDescription())) {
            desFlag = old.getDescription().equals(synonym.getDescription());
        }
        if (des.contains(synonym.getDescription()) && !desFlag.booleanValue() && !StringUtils.isEmpty((CharSequence)synonym.getDescription())) {
            return new CheckSynonymResult(Boolean.valueOf(false), "\u63cf\u8ff0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u4fdd\u5b58\u3002");
        }
        return new CheckSynonymResult(Boolean.valueOf(true), "");
    }

    public static String getId(Synonym synonym) {
        return synonym.getTenantId() + "_" + synonym.getEntityTypeName() + "_" + synonym.getProperNoun();
    }

    public Map<String, Synonym> getMap(List<Synonym> list) {
        int capactiy;
        HashMap<String, Synonym> map = new HashMap<String, Synonym>();
        if (CollectionUtils.isEmpty(list)) {
            return map;
        }
        int nThreads = 10;
        int n = capactiy = list.size() % nThreads > 0 ? list.size() / nThreads : list.size() / nThreads + 1;
        if (capactiy == 0) {
            capactiy = 1;
        }
        List partions = Lists.partition(list, (int)capactiy);
        ArrayList<Future> futures = new ArrayList<Future>(partions.size());
        for (int i = 0; i < partions.size(); ++i) {
            SynonymMapCallable callTask = new SynonymMapCallable((List)partions.get(i));
            futures.add(this.threadPoolTaskExecutor.submit((Callable)callTask));
        }
        for (Future future : futures) {
            try {
                Map threadMap = (Map)future.get();
                map.putAll(threadMap);
            }
            catch (Exception e) {
                log.error("getId error: ", (Throwable)e);
            }
        }
        return map;
    }

    public static Synonym twToCn(Synonym synonym) {
        HashSet set = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)synonym.getZh_CN())) {
            set.addAll(synonym.getZh_CN());
        }
        if (!CollectionUtils.isEmpty((Collection)synonym.getZh_TW())) {
            set.addAll(synonym.getZh_TW());
        }
        ArrayList zhCn = new ArrayList(set);
        synonym.setZh_CN(zhCn);
        synonym.setZh_TW(null);
        synonym.setZh_CN_Str(SynonymUtil.list2Str(zhCn));
        synonym.setZh_TW_Str(null);
        return synonym;
    }

    public CallableReturn groupSynonym(List<Synonym> list, Map<String, Synonym> oldMap, String tid, List<EntityType> entityTypes) {
        int capactiy;
        HashMap map = new HashMap();
        CallableReturn callableReturn = new CallableReturn();
        ArrayList excelVos = new ArrayList();
        map.put("1", new ArrayList());
        map.put("2", new ArrayList());
        if (CollectionUtils.isEmpty(list)) {
            return callableReturn;
        }
        int nThreads = 10;
        int n = capactiy = list.size() % nThreads > 0 ? list.size() / nThreads : list.size() / nThreads + 1;
        if (capactiy == 0) {
            capactiy = 1;
        }
        List partions = Lists.partition(list, (int)capactiy);
        ArrayList<Future> futures = new ArrayList<Future>(partions.size());
        for (int i = 0; i < partions.size(); ++i) {
            SynonymGroupCallable callTask = new SynonymGroupCallable((List)partions.get(i), oldMap, tid, entityTypes);
            futures.add(this.threadPoolTaskExecutor.submit((Callable)callTask));
        }
        for (Future future : futures) {
            try {
                CallableReturn on = (CallableReturn)future.get();
                ErrorSynonym errorSynonym = on.getErrorSynonym();
                if (errorSynonym == null) {
                    Map threadMap = on.getMap();
                    ((List)map.get("1")).addAll((Collection)threadMap.get("1"));
                    ((List)map.get("2")).addAll((Collection)threadMap.get("2"));
                    continue;
                }
                List synonymExcelVos = errorSynonym.getSynonymExcelVos();
                excelVos.addAll(synonymExcelVos);
            }
            catch (Exception e) {
                log.error("groupSynonym error: ", (Throwable)e);
            }
        }
        if (!CollectionUtils.isEmpty(excelVos)) {
            ErrorSynonym errorSynonym = new ErrorSynonym();
            errorSynonym.setId(UUID.randomUUID().toString());
            errorSynonym.setSynonymExcelVos(excelVos);
            callableReturn.setErrorSynonym(errorSynonym);
        }
        callableReturn.setMap(map);
        return callableReturn;
    }

    public static final RHSynonymHttpVo generateRHHttpVo(RHSynonymHttpVo rhSynonymHttpVo, String model, List<UpsertData> upsert_data, List<DeleteData> delete_data) {
        rhSynonymHttpVo.setKey("0");
        rhSynonymHttpVo.setAsynchronous(false);
        RhData rhData = new RhData();
        rhData.setModel(model);
        rhData.setTimeout(60);
        rhData.setTopic("AI");
        rhData.setMethod("CLU_IE");
        RhDataData rhDataData = new RhDataData();
        rhDataData.setIndex_name("clu_ie_words");
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(upsert_data)) {
            rhDataData.setUpsert_data(upsert_data);
        } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty(delete_data)) {
            rhDataData.setDelete_data(delete_data);
        }
        rhData.setData(rhDataData);
        rhSynonymHttpVo.setData(rhData);
        return rhSynonymHttpVo;
    }

    public static final UpsertData synonymToUpsertData(Synonym synonym) {
        UpsertData upsertData = new UpsertData();
        upsertData.setStandard_name(synonym.getProperNoun());
        upsertData.setSynonyms(synonym.getZh_CN());
        upsertData.setDescription(synonym.getDescription());
        upsertData.setEntity_type(synonym.getEntityTypeName());
        upsertData.setTenant_id(synonym.getTenantId());
        return upsertData;
    }

    public static final DeleteData synonymToDeleteData(Synonym synonym) {
        DeleteData deleteData = new DeleteData();
        deleteData.setTenant_id(synonym.getTenantId());
        deleteData.setStandard_name(synonym.getProperNoun());
        return deleteData;
    }
}

