/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.clients.IamService;
import com.digiwin.athena.agiledataquery.config.RedisLock;
import com.digiwin.athena.agiledataquery.synonym.dataSync.dao.SyncAppInfoDao;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.EntityTypeConfig;
import com.digiwin.athena.agiledataquery.synonym.dataSync.domain.LocalAppInfo;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.CronEntity;
import com.digiwin.athena.agiledataquery.synonym.domain.ExecuteFrequency;
import com.digiwin.athena.agiledataquery.synonym.domain.JobEntity;
import com.digiwin.athena.agiledataquery.synonym.http.OperatePlatformApiServiceHelper;
import com.digiwin.athena.agiledataquery.synonym.task.DataSyncQuartzJobExecution;
import com.digiwin.athena.agiledataquery.synonym.util.DateTimeToCronUtils;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Configuration
@EnableScheduling
@Component
public class DataSynchronizationTask {
    private static final Logger log = LoggerFactory.getLogger(DataSynchronizationTask.class);
    @Value(value="${currEnv}")
    private String currEnv;
    @Autowired
    private RedisLock redisLock;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private OperatePlatformApiServiceHelper operatePlatformApiServiceHelper;
    @Autowired
    private SyncAppInfoDao syncAppInfoDao;
    @Autowired
    private IamService iamService;

    @Scheduled(cron="${task-cron}")
    public void getData() {
        log.info("======start dataSynchronizationTask======");
        if (StringUtils.isEmpty((CharSequence)this.currEnv)) {
            log.info("\u5f53\u524d\u73af\u5883\u6ca1\u6709\u914d\u7f6e");
            return;
        }
        String dataSynchronizationTaskLock = null;
        try {
            dataSynchronizationTaskLock = this.redisLock.tryLock("dataSynchronizationTaskLock", 300000L);
            if (dataSynchronizationTaskLock != null) {
                List configs = this.syncAppInfoDao.getAll();
                if (CollectionUtils.isEmpty((Collection)configs)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u6570\u636e\u540c\u6b65\u914d\u7f6e");
                    return;
                }
                this.createJob(configs, "system", "");
            } else {
                log.info("======\u6ca1\u6709\u540c\u6b65\u6570\u636e\u4efb\u52a1\u7684\u9501======");
            }
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        finally {
            if (dataSynchronizationTaskLock != null) {
                log.info("\u91ca\u653e\u9501dataSynchronizationTaskLock\uff1a{}", (Object)dataSynchronizationTaskLock);
                this.redisLock.unlock("dataSynchronizationTaskLock", dataSynchronizationTaskLock);
            }
        }
        log.info("======finish dataSynchronizationTaskLock======");
    }

    public void createJob(List<LocalAppInfo> configs, String executeType, String entityType) throws Exception {
        for (LocalAppInfo config : configs) {
            if (config.getEffectiveness().booleanValue() && config.getAppSwitch().booleanValue()) {
                JSONArray data;
                List entityConfigList = this.syncAppInfoDao.findEntityConfigList(config.getAppName(), config.getAppType());
                Object login = this.iamService.login(config.getTenantId());
                JSONObject loginJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)login));
                String token = null;
                if (StringUtils.equals((CharSequence)config.getTenantId(), (CharSequence)loginJsonObject.getString("tenantId"))) {
                    token = loginJsonObject.getString("token");
                    log.info("\u521b\u5efa\u4efb\u52a1-\u767b\u5f55\u63a5\u53e3\u8fd4\u56detoken:{}", (Object)token);
                }
                JSONObject invoke = this.operatePlatformApiServiceHelper.apiInvoke(HttpMethod.GET, "{}", "/platform/value/all", token);
                ArrayList<CronEntity> list = new ArrayList<CronEntity>();
                if (Objects.nonNull(invoke) && !CollectionUtils.isEmpty((Collection)(data = invoke.getJSONArray("rows")))) {
                    for (int i = 0; i < data.size(); ++i) {
                        CronEntity cronEntity2 = (CronEntity)JSONObject.parseObject((String)JSON.toJSONString((Object)data.get(i)), CronEntity.class);
                        list.add(cronEntity2);
                    }
                }
                if (CollectionUtils.isEmpty(list)) {
                    log.info("\u672a\u83b7\u53d6\u5230\u8fd0\u8425\u5e73\u53f0\u53d6\u503c\u65b9\u6848\u914d\u7f6e");
                    return;
                }
                List<Object> cronEntities = new ArrayList();
                if ("manual".equals(executeType)) {
                    cronEntities = list.stream().filter(cronEntity -> StringUtils.equals((CharSequence)config.getAppType(), (CharSequence)cronEntity.getProductType()) && StringUtils.equals((CharSequence)config.getAppCode(), (CharSequence)cronEntity.getProductCode()) && StringUtils.equals((CharSequence)cronEntity.getEntityType(), (CharSequence)entityType)).collect(Collectors.toList());
                } else if (CollectionUtils.isEmpty((Collection)entityConfigList)) {
                    cronEntities = list.stream().filter(cronEntity -> StringUtils.equals((CharSequence)config.getAppType(), (CharSequence)cronEntity.getProductType()) && StringUtils.equals((CharSequence)config.getAppCode(), (CharSequence)cronEntity.getProductCode())).collect(Collectors.toList());
                } else {
                    List collect = entityConfigList.stream().filter(e -> Boolean.TRUE.equals(e.getEntitySwitch())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        List entityTypes = collect.stream().map(EntityTypeConfig::getEntityTypeName).collect(Collectors.toList());
                        cronEntities = list.stream().filter(cronEntity -> StringUtils.equals((CharSequence)config.getAppType(), (CharSequence)cronEntity.getProductType()) && StringUtils.equals((CharSequence)config.getAppCode(), (CharSequence)cronEntity.getProductCode()) && entityTypes.contains(cronEntity.getEntityType())).collect(Collectors.toList());
                    }
                }
                if (CollectionUtils.isEmpty(cronEntities)) continue;
                for (CronEntity cronEntity2 : cronEntities) {
                    String cron;
                    JobEntity job = new JobEntity();
                    BeanUtils.copyProperties((Object)cronEntity2, (Object)job);
                    String jobId = executeType + "_" + config.getTenantId() + "_" + config.getAppType() + "_" + config.getAppCode() + "_" + cronEntity2.getEntityType();
                    job.setCurrEnv(this.currEnv);
                    job.setTenantId(config.getTenantId());
                    job.setJobId(jobId);
                    job.setJobGroup(config.getTenantId());
                    job.setUserEmail(config.getUserEmail());
                    job.setExecuteType(executeType);
                    if ("manual".equals(executeType)) {
                        LocalDateTime localDateTime = LocalDateTime.now().plusSeconds(3L);
                        cron = DateTimeToCronUtils.getCron((LocalDateTime)localDateTime, (String)"YEAR");
                    } else {
                        ExecuteFrequency frequency = cronEntity2.getFrequency();
                        cron = DateTimeToCronUtils.getCron((ExecuteFrequency)frequency);
                    }
                    log.info("========dataSynchronizationTask.cronExpression:{}========", (Object)cron);
                    job.setCronExpression(cron);
                    this.createScheduleJob(this.scheduler, job);
                }
                continue;
            }
            log.info("========\u6570\u636e\u540c\u6b65\u914d\u7f6e\u5931\u6548\u6216\u672a\u5f00\u542f========\u914d\u7f6e\u4fe1\u606f:{}", (Object)config);
        }
    }

    public void createScheduleJob(Scheduler scheduler, JobEntity job) throws SchedulerException {
        String jobId = job.getJobId();
        String jobGroup = job.getJobGroup();
        JobDetail jobDetail = JobBuilder.newJob(DataSyncQuartzJobExecution.class).withIdentity(this.getJobKey(jobId, jobGroup)).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)job.getCronExpression());
        cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(DataSynchronizationTask.getTriggerKey((String)jobId, (String)jobGroup)).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        jobDetail.getJobDataMap().put("TASK_PROPERTIES", (Object)job);
        AthenaUser user = AthenaUserLocal.getUser();
        jobDetail.getJobDataMap().put("TASK_USER", (Object)user);
        if (!job.getStatus().booleanValue()) {
            log.info("\u53d6\u503c\u65b9\u6848\u5df2\u505c\u7528\uff0c\u5220\u9664\u4efb\u52a1\uff0cjob\u4fe1\u606f:{}", (Object)jobId);
            scheduler.deleteJob(this.getJobKey(jobId, jobGroup));
            return;
        }
        if (scheduler.checkExists(this.getJobKey(jobId, jobGroup))) {
            scheduler.deleteJob(this.getJobKey(jobId, jobGroup));
        }
        if (Objects.nonNull(this.getNextExecution(job.getCronExpression()))) {
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
    }

    public Date getNextExecution(String cronExpression) {
        try {
            CronExpression cron = new CronExpression(cronExpression);
            return cron.getNextValidTimeAfter(new Date(System.currentTimeMillis()));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public JobKey getJobKey(String jobId, String jobGroup) {
        return JobKey.jobKey((String)("TASK_CLASS_NAME" + jobId), (String)jobGroup);
    }

    public static TriggerKey getTriggerKey(String jobId, String jobGroup) {
        return TriggerKey.triggerKey((String)("TASK_CLASS_NAME" + jobId), (String)jobGroup);
    }
}

