/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.synonym.thread;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.synonym.dao.SynonymRest;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUser;
import com.digiwin.athena.agiledataquery.synonym.domain.AthenaUserLocal;
import com.digiwin.athena.agiledataquery.synonym.domain.Synonym;
import com.digiwin.athena.agiledataquery.synonym.service.impl.SynonymUtil;
import com.digiwin.athena.agiledataquery.synonym.util.RestUtil;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class SaveAndInsertThread
implements Callable<JSONObject> {
    private static final Logger log = LoggerFactory.getLogger(SaveAndInsertThread.class);
    private SynonymRest synonymDao;
    private RestTemplate restTemplate;
    private List<Synonym> updateList;
    private List<Synonym> insertList;
    private static String PUSH_IN = "/scrumbi/pushStandardWord";
    private String pushSynonymUrl;
    private AthenaUser user;
    private String appToken;

    public SaveAndInsertThread(SynonymRest synonymDao, RestTemplate restTemplate, List<Synonym> updateList, List<Synonym> insertList, String pushSynonymUrl, AthenaUser user, String appToken) {
        this.synonymDao = synonymDao;
        this.restTemplate = restTemplate;
        this.updateList = updateList;
        this.insertList = insertList;
        this.pushSynonymUrl = pushSynonymUrl;
        this.user = user;
        this.appToken = appToken;
    }

    public Boolean oldPushData(List<Synonym> sourceList) {
        try {
            List synonymHttpVos = SynonymUtil.parseSynonymHttpVo(sourceList);
            HttpHeaders headers = RestUtil.getHeaders();
            JSONObject jsonObject = new JSONObject();
            JSONArray objects = JSONArray.parseArray((String)JSONObject.toJSONString((Object)synonymHttpVos));
            jsonObject.put("standardWordDatas", (Object)objects);
            HttpEntity httpEntity = new HttpEntity((Object)jsonObject, (MultiValueMap)headers);
            log.info("tdd\u5f00\u59cb\u5411\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size());
            ResponseEntity result = null;
            try {
                result = this.restTemplate.postForEntity(this.pushSynonymUrl + PUSH_IN, (Object)httpEntity, JSONObject.class, new Object[0]);
            }
            catch (RestClientException e) {
                return false;
            }
            int statusCodeValue = result.getStatusCodeValue();
            if (statusCodeValue != 200) {
                log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size() + "\u5931\u8d25\u5185\u5bb9" + result.toString());
                return false;
            }
            JSONObject body = (JSONObject)result.getBody();
            if (body == null || StringUtils.isEmpty((CharSequence)body.getString("code")) || !body.getString("code").equals("200")) {
                log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u7684\u6570\u636e\u4e3a" + synonymHttpVos.size() + "\u5931\u8d25\u5185\u5bb9" + result.toString());
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.info("\u540c\u4e49\u8bcd\u5e93\u63a8\u9001\u6570\u636e\u5931\u8d25\uff0c\u63a8\u9001\u6570\u636e\u7684\u5730\u5740\u4e3a\uff1a" + this.pushSynonymUrl + PUSH_IN + "\u63a8\u9001\u5f02\u5e38\u4fe1\u606f" + exception.getMessage());
            return false;
        }
        return true;
    }

    public Boolean pushData(List<Synonym> sourceList) {
        return this.oldPushData(sourceList);
    }

    @Override
    public JSONObject call() throws Exception {
        AthenaUserLocal.setUser((AthenaUser)this.user);
        this.synonymDao.saveAll(this.updateList);
        this.synonymDao.insertAll(this.insertList);
        this.updateList.addAll(this.insertList);
        Boolean b = this.pushData(this.updateList);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)0);
        jsonObject.put("pushResult", (Object)b);
        jsonObject.put("size", (Object)this.updateList.size());
        return jsonObject;
    }
}

