/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.agiledataquery.context.DWServiceContext;
import com.digiwin.athena.agiledataquery.utils.DWBusinessException;
import com.digiwin.athena.agiledataquery.utils.DataMapFilter;
import com.digiwin.athena.agiledataquery.utils.I18nUtils;
import com.digiwin.athena.agiledataquery.utils.MergePolicy;
import com.digiwin.athena.agiledataquery.utils.ServiceUtils;
import com.digiwin.athena.agiledataquery.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

/*
 * Exception performing whole class analysis ignored.
 */
public class AthenaUtils {
    private static final Logger log = LoggerFactory.getLogger(AthenaUtils.class);
    @Value(value="${eocUrl}")
    private static String eocUrl;

    public static String getHeaderToken() throws DWBusinessException {
        Map profile = DWServiceContext.getContext().getRequestHeader();
        if (profile != null) {
            return profile.getOrDefault("token", null);
        }
        throw new DWBusinessException("not found token from requestHeader");
    }

    public static String getUserId() throws DWBusinessException {
        Map profile = DWServiceContext.getContext().getProfile();
        if (profile != null) {
            return profile.getOrDefault("id", null);
        }
        throw new DWBusinessException("not found userId from token");
    }

    public static String getTenantId() throws DWBusinessException {
        String tenantId = null;
        try {
            Map profile = DWServiceContext.getContext().getProfile();
            tenantId = profile.getOrDefault("tenantId", null);
        }
        catch (Exception e) {
            log.warn("Failed to get tenantId from context", (Throwable)e);
        }
        if (null == tenantId) {
            try {
                tenantId = DataMapFilter.getLoginInfo().getTenantId();
            }
            catch (Exception e2) {
                log.warn("Failed to get tenantId from DataMapFilter", (Throwable)e2);
            }
        }
        if (tenantId == null || tenantId.isEmpty()) {
            throw new DWBusinessException(I18nUtils.getValue((String)"knowledgegraph.tokenMissingTeant"));
        }
        if (null != DataMapFilter.getLoginInfo()) {
            DataMapFilter.getLoginInfo().setTenantId(tenantId);
        }
        return tenantId;
    }

    public static void mergeObject(Object source, Object to) {
        List fieldList = ServiceUtils.getFields(source.getClass());
        for (Field f : fieldList) {
            try {
                f.setAccessible(true);
                Object value = f.get(source);
                if (null == value) continue;
                f.set(to, value);
            }
            catch (Exception e) {
                log.error(e.toString());
            }
        }
    }

    public static void mergeObject(Object source, Object to, MergePolicy policy) {
        if (null == source || null == to) {
            return;
        }
        if (!AthenaUtils.isMapOrObject((Object)source)) {
            return;
        }
        if (policy.getParsed().contains(source)) {
            return;
        }
        policy.getParsed().add(source);
        String parent = policy.getPath();
        if (source instanceof Map) {
            Map sourcemap = (Map)source;
            Map tomap = (Map)to;
            sourcemap.forEach((k, v) -> {
                String path = parent + "." + k;
                if (null != v) {
                    Object v2 = tomap.get(k);
                    if (AthenaUtils.isMapOrObject((Object)v) && policy.pathMatch(path) && v2 != null) {
                        policy.setPath(path);
                        AthenaUtils.mergeObject((Object)v, v2, (MergePolicy)policy);
                    } else {
                        tomap.put(k, v);
                    }
                }
            });
        } else {
            List fieldList = ServiceUtils.getFields(source.getClass());
            for (Field f : fieldList) {
                try {
                    f.setAccessible(true);
                    Object value = f.get(source);
                    if (null == value) continue;
                    Object value2 = f.get(to);
                    if (value2 == null) {
                        f.set(to, value);
                        continue;
                    }
                    String path = parent + "." + f.getName();
                    if (AthenaUtils.isMapOrObject((Object)value) && policy.pathMatch(path)) {
                        policy.setPath(path);
                        AthenaUtils.mergeObject((Object)value, (Object)value2, (MergePolicy)policy);
                        continue;
                    }
                    if (value instanceof Map) {
                        Map mv = (Map)value;
                        if (mv.isEmpty()) continue;
                        Map mv2 = (Map)value2;
                        mv2.putAll(mv);
                        f.set(to, mv2);
                        continue;
                    }
                    if (value instanceof Collection) {
                        Collection cv = (Collection)value;
                        if (cv.size() <= 0) continue;
                        f.set(to, value);
                        continue;
                    }
                    f.set(to, value);
                }
                catch (Exception e) {
                    log.error(e.toString());
                }
            }
        }
    }

    private static boolean isMapOrObject(Object v) {
        if (v == null) {
            return false;
        }
        return !(v instanceof Collection) && !v.getClass().isArray() && !AthenaUtils.isPrimitive(v.getClass());
    }

    public static boolean isPrimitive(Class<?> c) {
        return c != null && (c.isPrimitive() || Number.class.isAssignableFrom(c) || Boolean.class.equals(c) || Character.class.isAssignableFrom(c) || CharSequence.class.isAssignableFrom(c));
    }

    public static void mergeList(List source, List to) {
        if (CollectionUtils.isEmpty((Collection)source) || CollectionUtils.isEmpty((Collection)to)) {
            return;
        }
        block0: for (Object s : source) {
            if (null == s) continue;
            for (Object t : to) {
                if (!s.equals(t)) continue;
                AthenaUtils.mergeObject(s, t);
                continue block0;
            }
        }
    }

    public static String postEoc(String uri, Header[] headers, String jsonbody, String appToken) {
        BasicHeader auth;
        String token;
        if (null == headers) {
            headers = Utils.requiredHeaders();
        }
        if (null != (token = DWServiceContext.getContext().getToken())) {
            auth = new BasicHeader("digi-middleware-auth-user", token);
            headers = (Header[])ArrayUtils.add((Object[])headers, (Object)auth);
        }
        if (null != appToken) {
            auth = new BasicHeader("digi-middleware-auth-app", appToken);
            headers = (Header[])ArrayUtils.add((Object[])headers, (Object)auth);
        }
        String url = eocUrl + uri;
        String body = Utils.postJson((String)url, (Header[])headers, (String)jsonbody);
        return body;
    }

    public static String postEoc(String uri, Header[] headers, String jsonbody, String token, String appToken) {
        BasicHeader auth;
        if (null == headers) {
            headers = Utils.requiredHeaders();
        }
        if (null != token) {
            auth = new BasicHeader("digi-middleware-auth-user", token);
            headers = (Header[])ArrayUtils.add((Object[])headers, (Object)auth);
        }
        if (null != appToken) {
            auth = new BasicHeader("digi-middleware-auth-app", appToken);
            headers = (Header[])ArrayUtils.add((Object[])headers, (Object)auth);
        }
        String url = eocUrl + uri;
        String body = Utils.postJson((String)url, (Header[])headers, (String)jsonbody);
        return body;
    }

    public static JSONObject getEoc(String uri, Header[] headers, Map<String, String> jsonbody, String appToken) throws IOException {
        BasicHeader auth;
        String token;
        if (null == headers) {
            headers = Utils.requiredHeaders();
        }
        if (null != (token = DWServiceContext.getContext().getToken())) {
            auth = new BasicHeader("digi-middleware-auth-user", token);
            headers = (Header[])ArrayUtils.add((Object[])headers, (Object)auth);
        }
        if (null != appToken) {
            auth = new BasicHeader("digi-middleware-auth-app", appToken);
            headers = (Header[])ArrayUtils.add((Object[])headers, (Object)auth);
        }
        String url = eocUrl + uri;
        String body = Utils.get((String)url, (Header[])headers, jsonbody);
        JSONObject jsonObject = JSON.parseObject((String)body);
        return jsonObject;
    }

    public static List<String> indexFiledName(String path) {
        ArrayList<String> filedNameList = new ArrayList<String>();
        File directory = new File(path);
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    filedNameList.add(file.getName());
                }
            }
        } else {
            log.error("\u8be5\u8def\u5f84\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u662f\u4e00\u4e2a\u76ee\u5f55");
        }
        return filedNameList;
    }

    public static String loadStream(String file) {
        try {
            String text = IOUtils.toString((URL)ServiceUtils.class.getResource(file), (String)"utf-8");
            return text;
        }
        catch (IOException e) {
            log.error(e.toString());
            return null;
        }
    }

    public static <T> T loadEntity(String file, Class<T> c) {
        String replaced = AthenaUtils.loadStream((String)file);
        Object entities = JSON.parseObject((String)replaced, c);
        return (T)entities;
    }

    public static String getCurrentLocale() {
        String locale = "zh_CN";
        DWServiceContext.ContextData context = DWServiceContext.getContext();
        if (Objects.isNull(context) || Objects.isNull(context.getRequestHeader())) {
            return locale;
        }
        return (String)context.getRequestHeader().get("locale");
    }

    public static String getTenantIdSilent() throws DWBusinessException {
        String tenantId = null;
        try {
            Map profile = DWServiceContext.getContext().getProfile();
            tenantId = profile.getOrDefault("tenantId", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null == tenantId) {
            try {
                tenantId = DataMapFilter.getLoginInfo().getTenantId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tenantId;
    }
}

