/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataquery.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public static <T> T toObject(String jsonString, Class<T> clz) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            return (T)JSON.parseObject((String)jsonString, clz);
        }
        return null;
    }

    public static <T> List<T> toList(String jsonString, Class<T> clz) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            return JSON.parseArray((String)jsonString, clz);
        }
        return Collections.emptyList();
    }

    public static String toJsonString(Object object) {
        if (object != null) {
            return JSON.toJSONString((Object)object);
        }
        return null;
    }

    public static Object getJsonValue(String json, String key) {
        if (StringUtils.isNotEmpty((CharSequence)json) && StringUtils.isNotEmpty((CharSequence)key)) {
            Object object = JSON.parse((String)json);
            if (object != null) {
                if (object instanceof JSONObject) {
                    return JsonUtil.getJsonValue((JSONObject)((JSONObject)object), (String)key);
                }
                if (object instanceof JSONArray) {
                    return JsonUtil.getJsonValue((JSONArray)((JSONArray)object), (String)key);
                }
            }
            return object;
        }
        log.warn("getJsonValue json:{}", (Object)json);
        throw new IllegalArgumentException("param json or key cannot be empty.");
    }

    public static Object getJsonValue(JSONObject jsonObject, String key) {
        if (jsonObject != null && StringUtils.isNotEmpty((CharSequence)key)) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                Object jsonValue;
                String s;
                String entryKey = (String)entry.getKey();
                Object value = entry.getValue();
                if (key.equals(entryKey)) {
                    return value;
                }
                if (value == null || !StringUtils.isNotEmpty((CharSequence)(s = value.toString())) || (jsonValue = JsonUtil.getJsonValue(value, (String)key)) == null) continue;
                return jsonValue;
            }
            return null;
        }
        throw new IllegalArgumentException("param jsonObject or key cannot by empty.");
    }

    public static Object getJsonValue(Object object, String key) {
        if (object != null && StringUtils.isNotEmpty((CharSequence)key)) {
            if (object instanceof JSONObject) {
                return JsonUtil.getJsonValue((JSONObject)((JSONObject)object), (String)key);
            }
            if (object instanceof JSONArray) {
                return JsonUtil.getJsonValue((JSONArray)((JSONArray)object), (String)key);
            }
        }
        return null;
    }

    public static Object getJsonValue(JSONArray jsonArray, String key) {
        if (jsonArray != null && StringUtils.isNotEmpty((CharSequence)key)) {
            for (Object next : jsonArray) {
                if (next == null) continue;
                return JsonUtil.getJsonValue(next, (String)key);
            }
        }
        return null;
    }

    public static <T> T toObject(String jsonString, TypeReference<T> typeReference) {
        if (StringUtils.isNotEmpty((CharSequence)jsonString)) {
            return (T)JSON.parseObject((String)jsonString, typeReference, (Feature[])new Feature[0]);
        }
        return null;
    }
}

