/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;

public class AdminClientWrapper {
    public Properties getProperties(String brokers) {
        Properties properties = new Properties();
        properties.setProperty("bootstrap.servers", brokers);
        properties.setProperty("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        properties.setProperty("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return properties;
    }

    public void describeTopics(String brokers, String topicName) throws IOException {
        Properties properties = this.getProperties(brokers);
        try (AdminClient adminClient = KafkaAdminClient.create((Properties)properties);){
            DescribeTopicsResult describeTopicsResult = adminClient.describeTopics(Collections.singleton(topicName));
            TopicDescription description = (TopicDescription)((KafkaFuture)describeTopicsResult.values().get(topicName)).get();
            System.out.print(description.toString());
        }
        catch (Exception e) {
            System.out.print("Describe denied\n");
            System.out.print(e.getMessage());
        }
    }

    public void deleteTopics(String brokers, String topicName) throws IOException {
        Properties properties = this.getProperties(brokers);
        try (AdminClient adminClient = KafkaAdminClient.create((Properties)properties);){
            DeleteTopicsResult deleteTopicsResult = adminClient.deleteTopics(Collections.singleton(topicName));
            ((KafkaFuture)deleteTopicsResult.values().get(topicName)).get();
            System.out.print("Topic " + topicName + " deleted");
        }
        catch (Exception e) {
            System.out.print("Delete Topics denied\n");
            System.out.print(e.getMessage());
        }
    }

    public void createTopics(String brokers, String topicName) throws IOException {
        Properties properties = this.getProperties(brokers);
        try (AdminClient adminClient = KafkaAdminClient.create((Properties)properties);){
            int numPartitions = 8;
            short replicationFactor = 3;
            NewTopic newTopic = new NewTopic(topicName, numPartitions, replicationFactor);
            CreateTopicsResult createTopicsResult = adminClient.createTopics(Collections.singleton(newTopic));
            ((KafkaFuture)createTopicsResult.values().get(topicName)).get();
            System.out.print("Topic " + topicName + " created");
        }
        catch (Exception e) {
            System.out.print("Create Topics denied\n");
            System.out.print(e.getMessage());
        }
    }
}

