/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai.utilities;

import com.digiwin.athena.ai.enums.RHResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;

public class utility {
    public static double getCurrentTimeStamp() {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        long localOffset = -(calendar.get(15) + calendar.get(16));
        double dd = (double)(date.getTime() - localOffset) / 24.0 / 3600.0 / 1000.0 + 25569.0;
        DecimalFormat df = new DecimalFormat("#0000000000.0000000000");
        return Double.valueOf(df.format(dd));
    }

    public static String getMD5Str(String str) {
        byte[] digest = null;
        try {
            MessageDigest md5 = MessageDigest.getInstance("md5");
            digest = md5.digest(str.getBytes("utf-8"));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String md5Str = DatatypeConverter.printHexBinary(digest);
        return md5Str.toUpperCase();
    }

    public static RHResult genResult(RHResult data) {
        RHResult result = new RHResult();
        try {
            result.code = data.code;
            result.msg = data.msg;
            result.data = data.data;
        }
        catch (Exception ex) {
            result.code = -4;
            result.msg = "except";
            result.data = data.toString();
        }
        return result;
    }

    public static RHResult genResult(int code, String msg, String data) {
        RHResult result = new RHResult();
        try {
            result.code = code;
            result.msg = msg;
            result.data = data;
        }
        catch (Exception ex) {
            result.code = -4;
            result.msg = "\u8cc7\u6599\u683c\u5f0f\u932f\u8aa4";
            result.data = "";
        }
        return result;
    }

    public static String ObjToJson(Object obj) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            return "";
        }
    }
}

