/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.ai;

import com.digiwin.athena.ai.Consumer;
import com.digiwin.athena.ai.Producer;
import com.digiwin.athena.ai.enums.CacData;
import com.digiwin.athena.ai.enums.ChatGPTData;
import com.digiwin.athena.ai.enums.GPTData;
import com.digiwin.athena.ai.enums.GPTEmbeddingData;
import com.digiwin.athena.ai.enums.MLOPS_ADData;
import com.digiwin.athena.ai.enums.OCR_CarData;
import com.digiwin.athena.ai.enums.RHData;
import com.digiwin.athena.ai.enums.RHResult;
import com.digiwin.athena.ai.utilities.utility;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;

public class RequestHDL {
    private void wait(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public RHResult toChatGPT(String url, String topic, String method, String model, String auth_user, Object data, int timeout, int topicqty) {
        RHResult result;
        ArrayList TimeDiff = new ArrayList();
        try {
            if (topic != "AI") {
                result = utility.genResult(-1, "topic \u932f\u8aa4", "");
            } else if (!Arrays.asList("GPT3", "ChatGPT", "ChatGPTV2", "GPT4").contains(method)) {
                result = utility.genResult(-2, "method \u932f\u8aa4", "");
            } else if (Arrays.asList("GPT3").contains(method) && !Arrays.asList("1", "2").contains(model) || Arrays.asList("ChatGPT", "ChatGPTV2", "GPT4").contains(method) && !Arrays.asList("1").contains(model)) {
                result = utility.genResult(-3, "model \u932f\u8aa4", "");
            } else {
                String mTask_ID = UUID.randomUUID().toString();
                RHData mValue = new RHData();
                mValue.AI = method;
                mValue.Model = model;
                mValue.Athena_ID = auth_user;
                mValue.Task_ID = mTask_ID;
                mValue.Timestamp = String.format("12%.7f", utility.getCurrentTimeStamp());
                mValue.Token = utility.getMD5Str("DIGIWIN" + new SimpleDateFormat("yyyyMMdd").format(new Date()));
                mValue.Data = data;
                mValue.Order = "1";
                mValue.TimeOut = timeout;
                mValue.TimeDiff = TimeDiff;
                String mValueJson = utility.ObjToJson(mValue);
                new Thread(() -> {
                    try {
                        this.wait(300);
                        Producer.produce(url, topic, mValueJson);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
                result = utility.genResult(Consumer.consume(url, auth_user, mTask_ID, timeout, topicqty));
            }
        }
        catch (Exception e) {
            result = utility.genResult(-4, e.getMessage(), "");
        }
        return result;
    }

    public RHResult requestChatGPT(String url, String topic, String method, String model, String auth_user, GPTData data, int timeout, int topicqty) {
        return this.toChatGPT(url, topic, method, model, auth_user, data, timeout, topicqty);
    }

    public RHResult requestChatGPT(String url, String topic, String method, String model, String auth_user, ChatGPTData data, int timeout, int topicqty) {
        return this.toChatGPT(url, topic, method, model, auth_user, data, timeout, topicqty);
    }

    public RHResult requestEmbedding(String url, String topic, String model, String auth_user, GPTEmbeddingData data, int timeout, int topicqty) {
        RHResult result;
        ArrayList TimeDiff = new ArrayList();
        try {
            if (topic != "AI") {
                result = utility.genResult(-1, "topic \u932f\u8aa4", "");
            } else if (!Arrays.asList("1").contains(model)) {
                result = utility.genResult(-3, "model \u932f\u8aa4", "");
            } else {
                String mTask_ID = UUID.randomUUID().toString();
                RHData mValue = new RHData();
                mValue.AI = "Embedding";
                mValue.Model = model;
                mValue.Athena_ID = auth_user;
                mValue.Task_ID = mTask_ID;
                mValue.Timestamp = String.format("12%.7f", utility.getCurrentTimeStamp());
                mValue.Token = utility.getMD5Str("DIGIWIN" + new SimpleDateFormat("yyyyMMdd").format(new Date()));
                mValue.Data = data;
                mValue.Order = "1";
                mValue.TimeOut = timeout;
                mValue.TimeDiff = TimeDiff;
                String mValueJson = utility.ObjToJson(mValue);
                new Thread(() -> {
                    try {
                        this.wait(300);
                        Producer.produce(url, topic, mValueJson);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
                result = utility.genResult(Consumer.consume(url, auth_user, mTask_ID, timeout, topicqty));
            }
        }
        catch (Exception e) {
            result = utility.genResult(-4, e.getMessage(), "");
        }
        return result;
    }

    public RHResult requestMLOPS_AD(String url, String topic, String model, String auth_user, MLOPS_ADData data, int timeout, int topicqty) {
        RHResult result;
        ArrayList TimeDiff = new ArrayList();
        try {
            if (!Arrays.asList("AI", "AI_Topic").contains(topic)) {
                result = utility.genResult(-1, "topic \u932f\u8aa4", "");
            } else {
                String mTask_ID = UUID.randomUUID().toString();
                RHData mADValue = new RHData();
                mADValue.AI = "MLOps_AD";
                mADValue.Model = model;
                mADValue.Athena_ID = auth_user;
                mADValue.Task_ID = mTask_ID;
                mADValue.Timestamp = String.format("12%.7f", utility.getCurrentTimeStamp());
                mADValue.Token = utility.getMD5Str("DIGIWIN" + new SimpleDateFormat("yyyyMMdd").format(new Date()));
                mADValue.Data = data;
                mADValue.Order = "1";
                mADValue.TimeOut = timeout;
                mADValue.TimeDiff = TimeDiff;
                String mADVJson = utility.ObjToJson(mADValue);
                new Thread(() -> {
                    try {
                        this.wait(300);
                        Producer.produce(url, topic, mADVJson);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
                result = utility.genResult(Consumer.consume(url, auth_user, mTask_ID, timeout, topicqty));
            }
        }
        catch (Exception e) {
            result = utility.genResult(-4, e.getMessage(), "");
        }
        return result;
    }

    public RHResult requestOCR_CAR(String url, String topic, String model, String auth_user, OCR_CarData data, CacData cac_data, int timeout, int topicqty) {
        RHResult result;
        ArrayList TimeDiff = new ArrayList();
        try {
            if (!Arrays.asList("AI", "AI_Topic").contains(topic)) {
                result = utility.genResult(-1, "topic \u932f\u8aa4", "");
            } else {
                String mTask_ID = UUID.randomUUID().toString();
                RHData mOCRValue = new RHData();
                mOCRValue.AI = "OCR_Car";
                mOCRValue.Model = model;
                mOCRValue.Athena_ID = auth_user;
                mOCRValue.Task_ID = mTask_ID;
                mOCRValue.Timestamp = String.format("12%.7f", utility.getCurrentTimeStamp());
                mOCRValue.Token = utility.getMD5Str("DIGIWIN" + new SimpleDateFormat("yyyyMMdd").format(new Date()));
                mOCRValue.Data = data;
                mOCRValue.CacData = cac_data;
                mOCRValue.Order = "1";
                mOCRValue.TimeOut = timeout;
                mOCRValue.TimeDiff = TimeDiff;
                String mOCRValueJson = utility.ObjToJson(mOCRValue);
                new Thread(() -> {
                    try {
                        this.wait(300);
                        Producer.produce(url, topic, mOCRValueJson);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }).start();
                result = utility.genResult(Consumer.consume(url, auth_user, mTask_ID, timeout, topicqty));
            }
        }
        catch (Exception e) {
            result = utility.genResult(-4, e.getMessage(), "");
        }
        return result;
    }
}

