package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.ChangeMsgStateDTO;
import com.digiwin.athena.aim.infrastructure.dingding.DingdingService;
import com.digiwin.athena.aim.infrastructure.dingding.dto.InviteSettingRequestDto;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/api/aim/v1/dingding")
public class DingDingManageController {


    @Autowired
    private DingdingService dingdingService;


    /**
     * 钉钉集成，邀请提醒  用户选择不再提醒
     *
     */
    @PostMapping("/remind/isNeverRemind")
    public ResponseEntity<?> recordInviteSetting(@RequestBody InviteSettingRequestDto inviteSettingRequestDto,
                                                 @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        //默认设置不再提醒
        if (inviteSettingRequestDto==null){
            inviteSettingRequestDto = new InviteSettingRequestDto();
            inviteSettingRequestDto.setIsNeverRemind(true);
        }
        //存储用户选择
        dingdingService.recordInviteSetting(inviteSettingRequestDto.getIsNeverRemind(),user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 获取当前邀请提醒的设置
     * @param user
     * @return
     */
    @GetMapping("/remind/getRemindSetting")
    public ResponseEntity<?> getRemindSetting(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return dingdingService.getRemindSetting(user);
    }
}