package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.model.EventDTO;
import com.digiwin.athena.aim.domain.message.service.EventMqService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value = "/api/aim/v1/event/mq")
public class EventMqController {

    @Autowired
    private EventMqService eventMqService;

    /**
     * 发送催办事件
     * @param eventDTO
     * @return
     */
    @PostMapping("/send/urge/deal/event")
    public ResponseEntity sendToClient(@RequestBody EventDTO eventDTO) {
        eventMqService.sendUrgeDealEventMq(eventDTO);
        return ResponseEntityWrapper.wrapperOk();
    }
}
