package com.digiwin.athena.aim.api;

import javax.annotation.Resource;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.digiwin.athena.aim.api.dto.DapEmpDisabledDTO;
import com.digiwin.athena.aim.domain.message.service.ExtCustomMsgService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;

/**
 * ExtCustomMsgController 外部定制的发送消息接口
 *
 * @author ljob
 * @date 2023/6/25
 * @since
 */
@RestController
@RequestMapping(value = "/api")
public class ExtCustomMsgController {

    @Resource
    private ExtCustomMsgService extCustomMsgService;

    /**
     * dap 人员停用时调用
     */
    @PostMapping("/app/tenant/emp/disabled")
    public ResponseEntity<?> getMsgSummary(@RequestBody DapEmpDisabledDTO dapEmpDisabledDTO) {
        extCustomMsgService.dapEmpDisabled(dapEmpDisabledDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

}
