package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordDO;
import com.digiwin.athena.aim.domain.message.model.MessageCenterRecordReq;
import com.digiwin.athena.aim.domain.message.model.MessageCenterSendReq;
import com.digiwin.athena.aim.domain.message.service.MessageCenterService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * MessageCenterController Description
 *
 * @author Ljob
 * @date 2025/1/24
 * @since
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/aim/message/center")
public class MessageCenterController {
    @Autowired
    private MessageCenterService messageCenterService;



    /**
     * 消息中心发送消息
     *
     * @param messageCenterSendReq
     * @return
     */
    @PostMapping(value = {"/send", "/open/send"})
    public ResponseEntity<?> send(@Validated @RequestBody MessageCenterSendReq messageCenterSendReq) {
        messageCenterService.send(messageCenterSendReq);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 消息中心发送消息
     *
     * @param messageCenterSendReq
     * @return
     */
    @PostMapping(value = {"/record"})
    public ResponseEntity<?> send(@Validated @RequestBody MessageCenterRecordReq messageCenterSendReq) throws IllegalAccessException{
        PageImpl<MessageCenterRecordDO> messageCenterRecordDOS = messageCenterService.record(messageCenterSendReq);
        return ResponseEntityWrapper.wrapperOk(messageCenterRecordDOS);
    }

}
