package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.api.dto.ChangeMsgStateDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageValidateGroup;
import com.digiwin.athena.aim.domain.message.service.MessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping(value = "/api/aim/v1")
public class MessageController {
    @Autowired
    private MessageService messageService;

    /**
     * 发送提醒
     *
     * @param messageDO
     * @return
     */
    @PostMapping(value = {"/message","/open/message"})
    public ResponseEntity<?> newMessage(@Validated(MessageValidateGroup.NewSingleMessage.class) @RequestBody MessageDO messageDO) {
        return messageService.newMessage(messageDO);
    }

    /**
     * 统计未读提醒
     *
     * @param importance
     * @return
     */
    @GetMapping("/message/unread/count")
    public ResponseEntity<?> getMsgUnreadCount(@RequestParam(value = "importance", required = false) Integer importance,
                                               @RequestParam(value = "channelType", required = false) String channelType) {
        return messageService.getMsgUnreadCount(importance, channelType);
    }

    @GetMapping("/message/changed")
    public ResponseEntity<?> getMsgChanged(@RequestParam(value = "importance", required = false) Integer importance) {
        return messageService.getMsgChanged(importance);
    }

    @GetMapping("/message/summary")
    public ResponseEntity<?> getMsgSummary(@RequestParam(value = "importance", required = false) Integer importance) {
        return messageService.getMsgSummary(importance);
    }

    @GetMapping("/message/{subTypeCategory}/summary")
    public ResponseEntity<?> getMsgSummaryBySubTypeCategory(@PathVariable("subTypeCategory") String subTypeCategory,
                                                            @RequestParam(value = "importance", required = false) Integer importance) {
        return messageService.getMsgSummaryBySubTypeCategory(subTypeCategory, importance);
    }

    @GetMapping("/worknews/message/summary")
    public ResponseEntity<?> getWorkNewsMsgSummary() {
        return messageService.getWorkNewsMsgSummary();
    }

    /**
     * 读取工作提醒
     *
     * @param changeMsgStateDTO
     * @return
     */
    @PostMapping("/message/read")
    public ResponseEntity<?> changeStateToRead(@RequestBody ChangeMsgStateDTO changeMsgStateDTO) {
        return messageService.changeStateToRead(changeMsgStateDTO);
    }

    /**
     * 删除已读的工作提醒
     *
     * @param changeMsgStateDTO
     * @return
     */
    @PostMapping("/message/read/delete")
    public ResponseEntity<?> deleteReadMsg(@RequestBody ChangeMsgStateDTO changeMsgStateDTO) {
        return messageService.deleteReadMsg(changeMsgStateDTO);
    }
}
