package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.model.MessageBatchUserDTO;
import com.digiwin.athena.aim.domain.message.model.MessageDO;
import com.digiwin.athena.aim.domain.message.model.MessageRemindDTO;
import com.digiwin.athena.aim.domain.message.service.MessageSendService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import lombok.extern.slf4j.Slf4j;


/**
 * 发送消息到消费方
 *
 * @since
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/aim/v2")
public class MessageSendController {
    @Autowired
    private MessageSendService messageSendService;

    /**
     * 发送消息
     *
     * @param messageDTO messageDTO
     */
    @PostMapping("/send/message/to/client")
    public ResponseEntity sendToClient(@Validated @RequestBody MessageBatchUserDTO messageDTO) {
        for (String userId : messageDTO.getUserIdList()) {
            messageSendService.sendToClient(messageDTO.getTenantId(), userId, messageDTO.getMessage());
        }
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 发送消息提醒
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:18
     */
    @PostMapping("/send/message/remind/to/client")
    public ResponseEntity sendRemindToClient(@Validated @RequestBody MessageRemindDTO messageDTO) {
        messageSendService.sendMessageRemindToClient(messageDTO);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 批量发送消息提醒
     *
     * @Author：SYQ
     * @Date：2022/4/11 15:18
     */
    @PostMapping("/batch/send/message/remind/to/client")
    public ResponseEntity batchSendRemindToClient(@Validated @RequestBody List<MessageRemindDTO> messageList) {
        messageSendService.sendMessageRemindToClient(messageList);
        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * App 消息批量推波
     *
     * @param messageBatchUserList messageBatchUserList
     */
    @PostMapping("/send/message/to/app/client/batch")
    public ResponseEntity sendToAppClient(@Validated @RequestBody List<MessageBatchUserDTO> messageBatchUserList) {
        for (MessageBatchUserDTO messageBatchUserDTO : messageBatchUserList) {
            List<String> userIdList = messageBatchUserDTO.getUserIdList();
            for (String userId : userIdList) {
                messageSendService.sendToAppClient(messageBatchUserDTO.getTenantId(), userId, messageBatchUserDTO.getMessage());
            }
        }
        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * App 消息推波
     *
     * @param message message
     */
    @PostMapping("/send/message/to/app/client")
    public ResponseEntity sendToAppClient(@Validated @RequestBody MessageDO message) {
        messageSendService.sendToAppClient(null, null, message);
        return ResponseEntityWrapper.wrapperOk();
    }

}
