package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.model.MessageTemplateDTO;
import com.digiwin.athena.aim.domain.message.service.MessageTemplateService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.stream.Collectors;

/**
 * MessageTemplateController Description
 *
 * @author sunqgz
 * @date 202/9/18
 * @since
 */
@Slf4j
@RestController
@RequestMapping(value = "/api/aim/template")
public class MessageTemplateController {

    @Autowired
    private MessageTemplateService messageTemplateService;

    /**
     * 新增模板
     *
     * @param MessageTemplateDTO
     * @return
     */
    @PostMapping("/insert")
    public ResponseEntity<?> insertMessageTemplate(@Validated @RequestBody MessageTemplateDTO MessageTemplateDTO) {
        try {
            messageTemplateService.insertMessageTemplate(MessageTemplateDTO);
            return ResponseEntityWrapper.wrapperOk();
        } catch (Exception e) {
            log.error("MessageTemplateController insert message template exception", e);
            return ResponseEntityWrapper.wrapperFail(1, e.getMessage());
        }
    }

    /**
     * 查询模板列表
     *
     * @param templateCode 模板code
     * @return
     */
    @GetMapping("/list")
    public ResponseEntity<?> queryMessageTemplateList(@RequestParam(required = false) String templateCode) {
        try {
            List<MessageTemplateDTO> templateDTOList = messageTemplateService.queryMessageTemplateList(templateCode);
            return ResponseEntityWrapper.wrapperOk(templateDTOList);
        } catch (Exception e) {
            log.error("MessageTemplateController query message template list exception", e);
            return ResponseEntityWrapper.wrapperFail(1, e.getMessage());
        }
    }
}