package com.digiwin.athena.aim.api;

import com.digiwin.athena.aim.domain.message.service.MiscHandleService;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

@RestController
@RequestMapping(value = "/api/aim/v1/misc")
public class MiscController {

    @Autowired
    private MiscHandleService miscHandleService;

    /**
     * 按照租户重置附件数据
     *
     * @return
     */
    @GetMapping("/demo/reset")
    public ResponseEntity<?> resetData() {

        miscHandleService.resetDataByTenantId();

        return ResponseEntityWrapper.wrapperOk();
    }


    /**
     * 根据租户信息删除对应的租户消息记录
     *
     * @param tenantId 租户id
     * @return 返回信息
     */
    @GetMapping("/message/deleteByTenant/{tenantId}")
    public ResponseEntity<?> deleteByTenant(@PathVariable("tenantId") String tenantId) {
        miscHandleService.deleteByTenantId(tenantId);
        return ResponseEntityWrapper.wrapperOk();
    }


    @GetMapping("/downFile")
    @SuppressWarnings("all")
    public ResponseEntity<org.springframework.core.io.Resource> downFile(String path) throws IOException {
        if (StringUtils.isBlank(path)) {
            throw new RuntimeException("文件路径为空");
        }
        // 文件路径
        Path filePath = Paths.get(path);
        org.springframework.core.io.Resource resource = new UrlResource(filePath.toUri());

        if (resource.exists() || resource.isReadable()) {
            // 设置响应头
            HttpHeaders headers = new HttpHeaders();
            headers.add(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=\"" + resource.getFilename() + "\"");
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);

            // 使用流式传输
            return ResponseEntity.ok()
                    .headers(headers)
                    .contentLength(resource.contentLength())
                    .body(resource);
        } else {
            throw new RuntimeException("文件不存在或不可读");
        }
    }

}