package com.digiwin.athena.aim.api;

import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCursor;
import org.apache.commons.collections.map.HashedMap;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * 修复数据的controller，避免每次都需要运维操作
 */
@RestController
@RequestMapping(value = "/api/aim/v1/")
public class RepairDataController {
    @Resource
    protected MongoTemplate msgMongoTemplate;

    /**
     * 查询数据的集合信息
     * @return
     */
    @GetMapping("/repair/msg/queryCollections")
    public ResponseEntity queryAllCollectionInfo()
    {
        //获取所有的collection信息
        Set<String> collectionInfo =  msgMongoTemplate.getCollectionNames();
        return ResponseEntityWrapper.wrapperOk(collectionInfo);
    }

    /**
     * 获取索引信息
     * @param collectionName 集合信息
     * @return
     */
    @GetMapping("/repair/msg/getIndexInfo")
    public ResponseEntity queryIndexInfo(@RequestParam(value = "collection", required = false) String collectionName)
    {

        ListIndexesIterable<Document> currentIndexes = msgMongoTemplate.getCollection(collectionName).listIndexes();
        MongoCursor<Document> cursor = currentIndexes.iterator();
        Set<Object> indexNames = new HashSet<>();
        while (cursor.hasNext()) {
            Object next = cursor.next();
            indexNames.add(next);
        }
        return ResponseEntityWrapper.wrapperOk(indexNames);

    }



    /**
     * 通过json方式创建索引
     * @param collectionName 集合信息
     * @return
     */
    @PostMapping("/repair/msg/setIndex")
    public ResponseEntity setIndex(@RequestParam(value = "collection", required = false) String collectionName,@RequestBody Document document)
    {

        String result = msgMongoTemplate.getCollection(collectionName).createIndex(document);
        return ResponseEntityWrapper.wrapperOk(result);
    }


    /**
     * 获取索引信息
     * @param collectionNames 集合信息
     * @return
     */
    @PostMapping("/repair/msg/batchSetIndex")
    public ResponseEntity batchSetIndex(@RequestParam(value = "collections", required = false) String collectionNames
            ,@RequestBody Document document)
    {
        String[] collArrs = collectionNames.split(",");
        Map<String,String> result = new HashedMap();
        for(String col:collArrs)
        {
            String tempResult = msgMongoTemplate.getCollection(col).createIndex(document);
            result.put(col,tempResult);
        }
        return ResponseEntityWrapper.wrapperOk(result);
    }


    /**
     * 获取索引信息
     * @param collectionName 集合信息
     * @Param indexName 索引名称
     * @return
     */
    @GetMapping("/repair/msg/dropIndex")
    public ResponseEntity dropIndex(@RequestParam(value = "collection", required = false) String collectionName
            ,@RequestParam(value = "indexName", required = false) String indexName)
    {

        try
        {
            msgMongoTemplate.getCollection(collectionName).dropIndex(indexName);
        }
        catch (Exception e)
        {
            return ResponseEntityWrapper.wrapperOk("删除索引异常");
        }

        return ResponseEntityWrapper.wrapperOk("删除索引成功");
    }

}
